@extends('backend.master')
@php
    $table_name='coupons';
@endphp
@section('table')
    {{$table_name}}
@stop
@push('styles')
    <style>
        html[dir="rtl"] .nice-select.primary_select {
            padding-left: 25px;
            padding-right: 20px;
        }

        html[dir="rtl"] .nice-select.primary_select .current {
            padding-right: 0;
            padding-left: 10px;
        }

        html[dir="rtl"] .nice-select.primary_select::after{
            left: 20px;
        }
    </style>
@endpush

@section('mainContent')

    {!! generateBreadcrumb() !!}

    <section class="admin-visitor-area up_st_admin_visitor">
        <div class="container-fluid p-0">
            <div class="row">
                <div class="col-lg-12">
                    <div class="row justify-content-center">
                        <div class="col-12">
                            <div class="box_header common_table_header">
                                <div class="main-title d-flex flex-wrap mb-0">
                                    <h3 class="mb-0 mr-30 mb_xs_15px mb_sm_20px">{{__('survey.Survey')}} {{__('survey.Participation')}} </h3>

                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="white-box ">
                        <div class="row">
                            <div class="col-lg-12 text-center">
                                <h2>


                                    @if ($survey->is_anonymous==1)
                                        {{__('survey.Anonymous')}}
                                    @else
                                        {{$user->name}}
                                    @endif
                                    |
                                    {{$survey->title}}
                                </h2>
                                {!! $survey->description !!}
                            </div>
                        </div>
                        <hr>
                        <input type="hidden" id="counter" value="{{$survey->questionAssigns->count()}}">
                        <input type="hidden" id="dom_url" value="{{url('/')}}">
                        {{--                        <form action="{{route('survey.survey_participate_store',$assign->id)}}" method="post">--}}
                        {{--                            <input type="hidden" name="assign_id" value="{{$assign->id}}">--}}
                        {{--                            @csrf--}}
                        <div class="">
                            @foreach ($survey->questionAssigns as $key => $assign)
                                @php
                                    $question =$assign->questionBank;
                                        $submitted_answer=$submitted_answers->where('question_id',$question->id)->first();

                                @endphp
                                <div class="single question row">
                                    <div class="col-lg-12">
                                        <h4>  {!! $question->question !!}</h4>
                                        <input type="hidden" name="question[]" value="{{$question->id}}">
                                    </div>
                                    <div class="col-lg-12 d-flex flex-wrap gap-3 flex-column flex-md-row mt-2">
                                        @if ($question->type!='textarea')
                                            @if ($question->type=='checkbox')
                                                @foreach ($question->questionMu as $attribute)
                                                    <div class="me-2 text-nowrap col">
                                                        <label class="primary_checkbox d-flex mr-12 ">
                                                            <input type="checkbox" disabled
                                                                   {{isset($submitted_answers) ? $submitted_answers->where('question_id',$question->id)->where('answer',$attribute->id)->first() ? 'checked':'':''}}
                                                                   name="survey_answer[{{$question->id}}][]"
                                                                   id="{{$attribute->id}}"
                                                                   value="{{$attribute->id}}"
                                                            >
                                                            <span
                                                                class="checkmark me-2 "></span> {{$attribute->title}}
                                                        </label>
                                                    </div>
                                                @endforeach
                                            @endif
                                            @if ($question->type=='radio')
                                                @foreach ($question->questionMu as $attribute)

                                                        <div class="me-2 text-nowrap col">
                                                        <label class="primary_checkbox d-flex mr-12 ">
                                                            <input type="radio" disabled
                                                                   {{isset($submitted_answer) ? $submitted_answer->answer == $attribute->id? 'checked':'':''}}
                                                                   name="survey_answer[{{$question->id}}]"
                                                                   id="{{$attribute->id}}"
                                                                   value="{{$attribute->id}}"
                                                            >
                                                            <span
                                                                class="checkmark me-2 "></span> {{$attribute->title}}
                                                        </label>
                                                    </div>
                                                @endforeach
                                            @endif
                                            @if ($question->type=='dropdown')
                                                <div class="primary_input ">

                                                    <select class="primary_select" disabled
                                                            name="survey_answer[{{$question->id}}]">
                                                        <option
                                                            value="">  {{ __('common.Select') }}   {{ __('common.Answer') }}</option>
                                                        @foreach ($question->questionMu as $attribute)
                                                            <option
                                                                {{isset($submitted_answer) ? $submitted_answer->answer == $attribute->id? 'selected':'':''}} value="{{$attribute->id}}">{{$attribute->title}}</option>
                                                        @endforeach
                                                    </select>
                                                </div>
                                            @endif
                                            @if ($question->type=='linear_scale')
                                                @php
                                                    $option =$question->number_of_option;
                                                @endphp
                                                @for ($i=1; $i<=$option;$i++)

                                                    <div class="d-inline-block text-center me-3">
                                                        <label class="primary_checkbox ">
                                                            <input type="radio" disabled
                                                                   {{isset($submitted_answer) ? $submitted_answer->answer == $i? 'checked':'':''}}
                                                                   name="survey_answer[{{$question->id}}]"
                                                                   id="{{$i}}"
                                                                   value="{{$i}}"
                                                            >
                                                            <span
                                                                class="checkmark me-2 "></span> {{$i}}
                                                        </label>
                                                    </div>

                                                @endfor
                                            @endif
                                        @else
                                            <div class="input-effect ">
                                                {!! $submitted_answers->where('question_id',$question->id)->first() ? $submitted_answers->where('question_id',$question->id)->first()->answer:'' !!}
                                            </div>
                                        @endif
                                    </div>
                                </div>
                                <br>
                            @endforeach
                        </div>

                    </div>
                </div>

            </div>
        </div>
    </section>

@endsection
@push('scripts')
    <script src="{{asset('public/backend/js/category.js')}}"></script>
    <script src="{{asset('Modules/Survey/Resources/assets/js/survey.js')}}"></script>
@endpush
