<?php

namespace Modules\Survey\Entities;

use App\Traits\Tenantable;
use App\User;
use Illuminate\Database\Eloquent\Model;

class SurveyAnswerSubmit extends Model
{
    use Tenantable;

    protected $guarded = ['id'];

    public function user()
    {
        return $this->belongsTo(User::class, 'user_id', 'id')->withDefault();
    }

    public function attribute()
    {
        return $this->belongsTo(SurveyQuestionSetAttribute::class, 'answer');
    }

    public function questionMu()
    {
        return $this->belongsTo(SurveyQuestionBankMuOption::class, 'answer');
    }
}
