<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateSurveysTable extends Migration
{
    public function up()
    {
        Schema::create('surveys', function (Blueprint $table) {
            $table->id();
            $table->string('title');
            $table->longText('description');
            $table->boolean('set_time')->nullable()->default(0);
            $table->string('publish_date')->nullable();
            $table->string('publish_time')->nullable();
            $table->integer('status')->nullable()->default(1);
            $table->integer('created_by')->nullable();
            $table->string('survey_for')->nullable()->comment('1=course, 2=group, 3=teacher, 4=student, 5=individual');
            $table->integer('assign_to')->nullable();
            $table->integer('group_id')->nullable();
            $table->integer('course_id')->nullable();
            $table->integer('role_id')->nullable();
            $table->integer('is_published')->nullable()->default(0);
            $table->integer('is_anonymous')->nullable()->default(0);
            $table->string('users_id')->nullable();
            $table->integer('lms_id')->default(1);
            $table->timestamps();
        });
    }

    public function down()
    {
        Schema::dropIfExists('surveys');
    }
}
