<?php


use Illuminate\Support\Facades\Route;

Route::middleware(['auth', 'admin'])->prefix('admin/ticket')->as('ticket.')->group(function () {

    Route::get('show/{id}', 'SupportTicketController@show')->name('tickets.show');
    Route::get('/assigned-ticket', 'SupportTicketController@my_ticket')->name('my_ticket');
    Route::get('/assigned-ticket/get-data', 'SupportTicketController@my_ticket_get_data')->name('my_ticket_get_data');
//    Route::get('/search-assigned', 'SupportTicketController@searchAssigned')->name('data_search_assigned');

    Route::get('course-tickets', 'SupportTicketController@courseTickets')->name('course_tickets.index')->middleware('RoutePermissionCheck:ticket.course_tickets.index');
    Route::get('course-tickets/datatable', 'SupportTicketController@courseTicketsDatatable')->name('course_tickets.datatable')->middleware('RoutePermissionCheck:ticket.course_tickets.index');

    Route::middleware(['RoutePermissionCheck:ticket.tickets.index'])->group(function () {
        Route::resource('tickets', 'SupportTicketController')->except('show', 'destroy');
        Route::post('/delete', 'SupportTicketController@destroy')->name('tickets.destroy');
        Route::get('/get-data', 'SupportTicketController@getData')->name('get-data');
        Route::get('/search', 'SupportTicketController@search')->name('data-search');
        Route::put('assign-user', 'SupportTicketController@assignedAgent')->name('assign.user');
    });


    Route::middleware(['RoutePermissionCheck:ticket.category.index'])->group(function () {
        //category
        Route::get('/categories', 'SupportTicketCategoryController@index')->name('category.index');
        Route::post('/categories/store', 'SupportTicketCategoryController@store')->name('category.store');
        Route::get('/categories/edit', 'SupportTicketCategoryController@edit')->name('category.edit');
        Route::post('/categories/edit', 'SupportTicketCategoryController@update')->name('category.update');
        Route::post('/categories/delete', 'SupportTicketCategoryController@destroy')->name('category.delete');
        Route::post('/categories/status', 'SupportTicketCategoryController@status')->name('category.status');
    });

    Route::middleware(['RoutePermissionCheck:ticket.priority.index'])->group(function () {
        //priorities
        Route::get('/priorities', 'TicketPriorityController@index')->name('priority.index');
        Route::post('/priorities/store', 'TicketPriorityController@store')->name('priority.store');
        Route::get('/priorities/edit', 'TicketPriorityController@edit')->name('priority.edit');
        Route::post('/priorities/update', 'TicketPriorityController@update')->name('priority.update');
        Route::post('/priorities/delete', 'TicketPriorityController@destroy')->name('priority.delete');
        Route::post('/priorities/status', 'TicketPriorityController@status')->name('priority.status');
    });

    Route::middleware(['RoutePermissionCheck:ticket.status.index'])->group(function () {
        //status
        Route::get('/status', 'TicketStatusController@index')->name('status.index');
        Route::post('/status/store', 'TicketStatusController@store')->name('status.store');
        Route::get('/status/edit', 'TicketStatusController@edit')->name('status.edit');
        Route::post('/status/update', 'TicketStatusController@update')->name('status.update');
        Route::post('/status/delete', 'TicketStatusController@destroy')->name('status.delete');
        Route::post('/status/status', 'TicketStatusController@status')->name('status.status');
    });
});

Route::middleware(['auth'])->prefix('admin/ticket')->as('ticket.')->group(function () {
    Route::post('/attach-file-delete', 'SupportTicketController@attachFileDelete')->name('attach-file-delete');
    Route::post('message', 'TicketMessageController@store')->name('message');
});


Route::middleware(['auth'])->prefix('ticket')->as('ticket.')->group(function () {
    Route::get('/attach-file-view/{id}', 'TicketMessageController@attachFileView')->name('attach_file_view');
});
Route::prefix('student')->middleware(['auth', 'student', 'RoutePermissionCheck:student.support-ticket.index'])->as('student.')->group(function () {
    //support ticket
    route::get('/support-ticket', 'UserSupportTicketController@index')->name('support-ticket.index');
    route::get('/support-ticket/get-data', 'UserSupportTicketController@getdata')->name('support-ticket.get-data');
    route::get('/support-ticket/create', 'UserSupportTicketController@create')->name('support-ticket.create');
    route::get('/support-ticket/{id}/edit', 'UserSupportTicketController@edit')->name('support-ticket.edit');
    route::post('/support-ticket', 'UserSupportTicketController@store')->name('support-ticket.store');
    route::post('/support-ticket/update/{id}', 'UserSupportTicketController@update')->name('support-ticket.update');
    route::get('/support-ticket/{id}/show', 'UserSupportTicketController@show')->name('support-ticket.show');
    route::post('/support-ticket/message', 'TicketMessageController@store')->name('ticket.message');
    Route::post('/support-ticket-delete', 'UserSupportTicketController@destroy')->name('tickets.destroy');
 });
