<?php

namespace Modules\SupportTicket\Http\Controllers;

use App\Traits\ImageStore;
use App\Traits\SendNotification;
use App\User;
use Brian2694\Toastr\Facades\Toastr;
use Carbon\Carbon;
use Illuminate\Http\Request;
use Illuminate\Routing\Controller;
use Illuminate\Support\Facades\Response;
use Modules\SupportTicket\Entities\SupportTicket;
use Modules\SupportTicket\Entities\SupportTicketFile;
use Modules\SupportTicket\Entities\TicketMessage;
use Modules\SupportTicket\Entities\TicketMessageFile;

class TicketMessageController extends Controller
{
    use ImageStore, SendNotification;

    public function store(Request $request)
    {
        $validate_rules = [
            'text' => 'required',
            'ticket_id' => 'required|numeric',
            'ticket_file.*' => 'nullable|mimes:jpg,jpeg,bmp,png,doc,docx,csv,rtf,xlsx,xls,txt,pdf,sql',
            'status_id' => 'nullable'

        ];


        $request->validate($validate_rules, validationMessage($validate_rules));


        try {

            $ticket_id = $request->input('ticket_id');
            if ($request->text != '') {
                $ticketMessage = TicketMessage::create([
                    'ticket_id' => $ticket_id,
                    'text' => clean($request->input('text')),
                    'user_id' => auth()->user()->id,
                    'type' => $request->type
                ]);
                if ($request->hasFile('ticket_file')) {

                    if (!file_exists('public/upload/message_ticket_image/')) {
                        mkdir('public/upload/message_ticket_image/', 0777, true);
                    }

                    $files = $request->file('ticket_file');
                    foreach ($files as $file) {
                        if ($file) {
                            $file_original_name = $file->getClientOriginalName();
                            $fileName = md5($file->getClientOriginalName() . time()) . "." . $file->getClientOriginalExtension();
                            $file->move('public/upload/message_ticket_image/', $fileName);
                            $filePath = 'public/upload/message_ticket_image/' . $fileName;

                            $messageFile = new TicketMessageFile();
                            $messageFile->message_id = $ticketMessage->id;
                            $messageFile->url = $filePath;
                            $messageFile->name = $file->getClientOriginalName();
                            $messageFile->type = $file->getClientOriginalExtension();
                            $messageFile->save();
                        }

                    }
                }
            }

            $status_id = $request->input('status_id');

            $this->updateTicketStatus($ticket_id, $status_id, Carbon::now());


            $supportTicket = SupportTicket::find($ticketMessage->ticket_id);
            if (auth()->user()->role_id == 1 || auth()->user()->role_id == 4) {
                $users[] = $supportTicket->user;
            } else {
                $users = User::where('role_id', 1)->get();
                $users[] = $supportTicket->assignUser;
            }

            foreach ($users as $user) {
                $this->sendNotification('REPLY_SUPPORT_TICKET', $user, [
                    'replied_by' => $ticketMessage->user->name,
                    'ticket_no' => $supportTicket->reference_no,
                    'time' => now(),
                    'category' => $supportTicket->category->name,
                    'priority' => $supportTicket->priority->name,
                    'subject' => $supportTicket->subject,
                    'status' => $supportTicket->status->name,
                    'message' => $ticketMessage->text,
                ]);
            }

            Toastr::success(trans('common.Operation successful'), trans('common.Success'));
            return redirect()->back();
        } catch (\Exception $e) {
            Toastr::error(trans('common.Operation failed'), trans('common.Failed'));
            return redirect()->back();
        }
    }


    public function updateTicketStatus($ticketId, $statusId, $updated_at)
    {
        $ticket = SupportTicket::findOrFail($ticketId);

        if (!$statusId) {
            $statusId = $ticket->status_id;
        }
        if ($ticket->status_id != $statusId) {
            $ticket->status_id = $statusId;
        }
        $ticket->updated_at = $updated_at;

        $ticket->save();
    }

    public function attachFileView($id)
    {
        try {
            $e = explode('-', $id);
            $m = $e[0];
            $id = decrypt($e[1]);
            if ($m == 'tf') {
                $file = SupportTicketFile::find($id);
            } else {
                $file = TicketMessageFile::find($id);
            }
            if ($file->type == 'pdf') {
                $filename = $file->name;
                $path = $file->url;
                return Response::make(file_get_contents($path), 200, [
                    'Content-Type' => 'application/pdf',
                    'Content-Disposition' => 'inline; filename="' . $filename . '"'
                ]);
            } elseif ($file->type == 'jpg' || $file->type == 'png' || $file->type == 'jpeg') {
                return response()->file($file->url);
            } else {
                $path = $file->url;
                $filename = $file->name;
                return response()->download($path, $filename);
            }
        } catch (\Exception $e) {

            Toastr::error(trans('common.Operation failed'), trans('common.Failed'));
            return redirect()->back();
        }
    }


}
