@push('scripts')
    <script type="text/javascript">

        (function ($) {
            "use strict";

            $(document).ready(function () {

                $(document).on('change', '#business_country', function (event) {
                    let country = $('#business_country').val();

                    $('.preloader').removeClass('d-none');
                    if (country) {
                        let base_url = $('#url').val();
                        let url = base_url + '/store/pickup-location/get-state?country_id=' + country;

                        $('#business_state').empty();

                        $('#business_state').append(
                            `<option value="" disabled selected>{{_trans('common.Select One')}}</option>`
                        );
                        $('#business_state').niceSelect('update');
                        $('#business_city').empty();
                        $('#business_city').append(
                            `<option value="" disabled selected>{{_trans('common.Select One')}}</option>`
                        );
                        $('#business_city').niceSelect('update');
                        $.get(url, function (data) {

                            $.each(data, function (index, stateObj) {
                                $('#business_state').append('<option value="' + stateObj.id + '">' + stateObj.name + '</option>');
                            });

                            $('#business_state').niceSelect('update');
                            $('.preloader').addClass('d-none');
                        });
                    }
                });

                $(document).on('change', '#business_state', function (event) {
                    let state = $('#business_state').val();

                    $('.preloader').removeClass('d-none');
                    if (state) {
                        let base_url = $('#url').val();
                        let url = base_url + '/store/pickup-location/get-city?state_id=' + state;

                        $('#business_city').empty();

                        $('#business_city').append(
                            `<option value="" selected>{{__('common.select_one')}}</option>`
                        );
                        $('#business_city').niceSelect('update');

                        $.get(url, function (data) {

                            $.each(data, function (index, cityObj) {
                                $('#business_city').append('<option value="' + cityObj.id + '">' + cityObj.name + '</option>');
                            });

                            $('#business_city').niceSelect('update');
                            $('.preloader').addClass('d-none');
                        });
                    }
                });

                $(document).on("click", ".view_row", function (event) {
                    event.preventDefault();
                    $('.preloader').removeClass('d-none');
                    let id = $(this).data("id");
                    let url = "{{route('store.pickuplocation.show',':id')}}";
                    url = url.replace(':id', id);
                    $.get(url, function (data) {
                        $('#append_html').html(data);
                        $('.preloader').addClass('d-none');
                        $('#view_modal').modal('show');
                    });

                });

                $(document).on("click", ".delete_row", function (event) {
                    event.preventDefault();
                    let id = $(this).data("id");
                    $('#pickup_location_delete_id').val(id);
                    $('#pickup_location_delete_modal').modal('show');

                });

                $(document).on('submit', '#pickup_location_delete_form', function (event) {
                    event.preventDefault();
                    $('.preloader').removeClass('d-none');
                    $('#pickup_location_delete_modal').modal('hide');
                    var formData = new FormData();
                    var id = $('#pickup_location_delete_id').val();
                    var action_url = "{{ url('store/pickup-location/destroy') }}" + '/' + id;
                    formData.append('_token', "{{ csrf_token() }}");
                    formData.append('id', $('#pickup_location_delete_id').val());
                    $.ajax({
                        url: action_url,
                        type: "GET",
                        cache: false,
                        contentType: false,
                        processData: false,
                        data: formData,
                        success: function (response) {
                            if (response.msg) {
                                toastr.warning(response.msg);
                                $("#pre-loader").addClass('d-none');
                            } else {
                                // resetAfterChange(response.TableData);
                                toastr.success("{{_trans('product.Deleted Successfully')}}", "{{__('common.Success')}}")
                                $('.preloader').addClass('d-none');
                                $('.create_div').html(response.createForm);
                                $(".primary_select").niceSelect();
                                location.reload();
                            }

                        },
                        error: function (response) {

                            if (response.responseJSON.error) {
                                toastr.error(response.responseJSON.error, "{{__('common.Error')}}");
                                $('.preloader').addClass('d-none');
                                return false;
                            }
                            toastr.error("{{_trans('common.Something Wrong')}}'", "{{__('common.Error')}}");
                        }
                    });
                });

                $(document).on('change', '.status_change', function (event) {
                    event.preventDefault();
                    let status = 0;
                    if ($(this).prop('checked')) {
                        status = 1;
                    } else {
                        status = 0;
                    }
                    let id = $(this).data('id');
                    $('.preloader').removeClass('d-none');
                    let formData = new FormData();
                    formData.append('_token', "{{ csrf_token() }}");
                    formData.append('id', id);
                    formData.append('status', status);

                    $.ajax({
                        url: "{{ route('store.pickuplocation.status') }}",
                        type: "POST",
                        cache: false,
                        contentType: false,
                        processData: false,
                        data: formData,
                        success: function (response) {
                            toastr.success("{{_trans('common.Updated Successfully')}}", "{{__('common.Success')}}");
                            $('.preloader').addClass('d-none');
                            location.reload();
                        },
                        error: function (response) {

                            if (response.responseJSON.error) {
                                toastr.error(response.responseJSON.error, "{{__('common.Error')}}");
                                $('.preloader').addClass('d-none');
                                return false;
                            }
                            toastr.error("{{_trans('common.Error Message')}}", "{{__('common.Error')}}");
                            $('.preloader').addClass('d-none');
                        }
                    });

                });

                $(document).on('change', '.set_default', function (event) {
                    event.preventDefault();
                    let set_default = 0;
                    if ($(this).prop('checked')) {
                        set_default = 1;
                    } else {
                        set_default = 0;
                    }
                    let id = $(this).data('id');
                    $('.preloader').removeClass('d-none');
                    let formData = new FormData();
                    formData.append('_token', "{{ csrf_token() }}");
                    formData.append('id', id);
                    formData.append('set_default', set_default);

                    $.ajax({
                        url: "{{ route('store.pickuplocation.set_default') }}",
                        type: "POST",
                        cache: false,
                        contentType: false,
                        processData: false,
                        data: formData,
                        success: function (response) {
                            // resetAfterChange(response.TableData);
                            toastr.success("{{__('product.updated_successfully')}}", "{{__('common.Success')}}");
                            $('.preloader').addClass('d-none');
                            location.reload();
                        },
                        error: function (response) {

                            if (response.responseJSON.error) {
                                toastr.error(response.responseJSON.error, "{{__('common.error')}}");
                                $('.preloader').addClass('d-none');
                                return false;
                            }
                            toastr.error("{{__('common.error_message')}}", "{{__('common.error')}}");
                            $('.preloader').addClass('d-none');
                        }
                    });

                });


                function create_form_reset() {
                    $('#createForm')[0].reset();
                    $('.primary_select').niceSelect('update');
                }

                function resetAfterChange(response) {
                    $('#item_list').html(response);
                    CRMTableThreeReactive();
                }

                function showValidationErrors(formType, errors) {
                    $(formType + ' #error_pickup_location').text(errors.pickup_location);
                    $(formType + ' #error_name').text(errors.name);
                    $(formType + ' #error_email').text(errors.email);
                    $(formType + ' #error_phone').text(errors.phone);
                    $(formType + ' #error_address').text(errors.address);
                    $(formType + ' #error_address_2').text(errors.address_2);
                    $(formType + ' #error_pin_code').text(errors.pin_code);
                    $(formType + ' #error_country_id').text(errors.country_id);
                    $(formType + ' #error_state_id').text(errors.state_id);
                    $(formType + ' #error_city_id').text(errors.city_id);
                }

                function resetValidationError() {
                    $('#error_pickup_location').text('');
                    $('#error_name').text('');
                    $('#error_email').text('');
                    $('#error_phone').text('');
                    $('#error_address').text('');
                    $('#error_address_2').text('');
                    $('#error_pin_code').text('');
                    $('#error_country_id').text('');
                    $('#error_state_id').text('');
                    $('#error_city_id').text('');
                }
            });


            dataTableOptions = updateColumnExportOption(dataTableOptions, [0, 1, 2, 3, 4]);

            $('#lms_table').DataTable(dataTableOptions);

        })(jQuery);

    </script>
@endpush
