@extends('backend.master')


@php
    $table_name = 'product_categories';
@endphp
@section('table')
    {{ $table_name }}
@endsection

@section('mainContent')

    @php
        $LanguageList = getLanguageList();
    @endphp

    {!! generateBreadcrumb() !!}

    <section class="admin-visitor-area up_st_admin_visitor">
        <div class="container-fluid p-0">
            <div class="row">
                <div class="col-lg-4">
                    <div class="white-box mb_30  student-details header-menu">

                        <div class="box_header common_table_header">
                            <div class="main-title d-md-flex mb-0">
                                <h3 class="mb-0">
                                    @if (!isset($edit))
                                        {{ _trans('product.Add New Category') }}
                                    @else
                                        {{ _trans('product.Update Category') }}
                                    @endif
                                </h3>
                                @if (isset($edit))
                                    @if (permissionCheck('store.category.index'))
                                        <a href="{{ route('store.category.index') }}"
                                           class="primary-btn small fix-gr-bg ms-4"
                                           style="line-height: 25px;" title="{{ __('courses.Add New') }}">+</a>
                                    @endif
                                @endif
                            </div>
                        </div>

                        <div class="row pt-0">
                            @if (isModuleActive('FrontendMultiLang'))
                                <ul class="nav nav-tabs no-bottom-border  mt-sm-md-20 mb-10 ms-3" role="tablist">
                                    @foreach ($LanguageList as $key => $language)
                                        <li class="nav-item">
                                            <a class="nav-link  @if (auth()->user()->language_code == $language->code) active @endif"
                                               href="#element{{ $language->code }}" role="tab"
                                               data-bs-toggle="tab">{{ $language->native }} </a>
                                        </li>
                                    @endforeach
                                </ul>
                            @endif
                        </div>

                        @if (isset($edit))
                            <form action="{{ route('store.category.update') }}" method="POST" id="category-form"
                                  name="category-form" enctype="multipart/form-data">
                                <input type="hidden" name="id" value="{{ $edit->id }}">
                                @else
                                    @if (permissionCheck('store.category.store'))
                                        <form action="{{ route('store.category.store') }}" method="POST"
                                              id="category-form"
                                              name="category-form" enctype="multipart/form-data">
                                            @endif
                                            @endif
                                            @csrf

                                            <div class="tab-content">
                                                @foreach ($LanguageList as $key => $language)
                                                    <div role="tabpanel"
                                                         class="tab-pane fade @if (auth()->user()->language_code == $language->code) show active @endif  "
                                                         id="element{{ $language->code }}">
                                                        <div class="row">
                                                            <div class="col-xl-12">
                                                                <div class="primary_input mb-25">
                                                                    <label class="primary_input_label"
                                                                           for="nameInput">{{ __('common.Name') }}
                                                                        <strong class="text-danger">*</strong></label>
                                                                    <input name="name[{{ $language->code }}]"
                                                                           id="nameInput"
                                                                           class="primary_input_field name {{ @$errors->has('name') ? ' is-invalid' : '' }}"
                                                                           placeholder="{{ __('common.Name') }}"
                                                                           type="text"
                                                                           value="{{ isset($edit) ? $edit->getTranslation('title', $language->code) : old('title.' . $language->code) }}">

                                                                    @if ($errors->has('name'))
                                                                        <span class="invalid-feedback d-block mb-10"
                                                                              role="alert">
                                                        <strong>{{ @$errors->first('name') }}</strong>
                                                    </span>
                                                                    @endif

                                                                </div>

                                                            </div>
                                                        </div>


                                                    </div>
                                                @endforeach

                                            </div>
                                            <div class="row">

                                                <div class="col-xl-12">
                                                    <div class="primary_input mb-25">
                                                        <label class="primary_input_label"
                                                               for="parent">{{ __('common.Parent') }}</label>
                                                        <select class="primary_select mb-25" name="parent" id="parent">
                                                            <option value="">{{ __('common.None') }}</option>
                                                            @foreach ($categories as $category)
                                                                @if (isset($edit) && $category->id == $edit->id)
                                                                    @php
                                                                        continue;
                                                                    @endphp
                                                                @endif
                                                                <option value="{{ $category->id }}"
                                                                    {{ isset($edit) ? ($edit->parent_id == $category->id ? 'selected' : old('parent')) : old('parent') }}>
                                                                    {{ $category->title }}</option>
                                                            @endforeach
                                                        </select>
                                                    </div>
                                                </div>

                                                <div class="col-xl-12">
                                                    <div class="primary_input mb-25">
                                                        <label class="primary_input_label"
                                                               for="position_order">{{ __('courses.Position Order') }}</label>
                                                        <select class="primary_select mb-25" name="position_order"
                                                                id="position_order">
                                                            @for ($i = 1; $i <= $max_id; $i++)
                                                                <option value="{{ $i }}"
                                                                    {{ isset($edit) ? ($edit->position_order == $i ? 'selected' : old('position_order')) : old('position_order') }}>
                                                                    {{ translatedNumber($i) }}</option>
                                                            @endfor
                                                        </select>
                                                    </div>
                                                </div>


                                                <div class="col-lg-12 mt-10">
                                                    <div class=" mb-15">

                                                        <x-upload-file
                                                            name="image"
                                                            type="image"
                                                            media_id="{{isset($edit)?$edit->image_media?->media_id:''}}"
                                                            label="{{ __('frontendmanage.Icon') }}"
                                                            note="{{__('student.Recommended size')}} ({{translatedNumber('200x200')}})"
                                                        />

                                                    </div>
                                                </div>


                                                @php
                                                    $tooltip = '';
                                                    if (!permissionCheck('store.category.store')) {
                                                        $tooltip = trans('courses.You have no permission to add');
                                                    }
                                                @endphp
                                                <div class="col-lg-12 text-center">
                                                    <div class="d-flex justify-content-center pt_20">
                                                        <button type="submit" class="primary-btn semi_large fix-gr-bg"
                                                                data-bs-toggle="tooltip"
                                                                title="{{ @$tooltip }}" id="save_button_parent">
                                                            <i class=" fa fa-check "></i>
                                                            @if (!isset($edit))
                                                                {{ __('common.Save') }}
                                                            @else
                                                                {{ __('common.Update') }}
                                                            @endif
                                                        </button>


                                                    </div>
                                                </div>
                                            </div>

                                        </form>
                    </div>


                </div>
                <div class="col-lg-8">
                    <div class="white-box">
                        <div class="box_header common_table_header">
                            <div class="main-title d-md-flex mb-0">
                                <h3 class="mb-0" id="page_title">{{ __('product.Product Category List') }}</h3>
                            </div>
                        </div>
                        <div class="  QA_section QA_section_heading_custom check_box_table">
                            <div class="QA_table ">
                                <div class="">
                                    <table id="lms_table" class="table table-data">
                                        <thead>
                                        <tr>
                                            <th scope="col">{{ __('common.SL') }}</th>
                                            <th scope="col">{{ __('common.Name') }}</th>
                                            <th scope="col">{{ __('common.Parent') }}</th>
                                            <th scope="col">{{ __('common.Position') }} {{ __('common.ID') }}</th>
                                            <th scope="col">{{ __('frontendmanage.Icon') }}</th>
                                            <th scope="col">{{ __('common.Status') }}</th>
                                            <th scope="col">{{ __('common.Action') }}</th>
                                        </tr>
                                        </thead>
                                        <tbody>
                                        @foreach ($categories as $key => $category)
                                            <tr>
                                                <td>{{translatedNumber(++$key) }}</td>
                                                <td> {{ checkParent($category) }} {{ @$category->title }}</td>
                                                <td>{{ @$category->parent->title }}</td>
                                                <td>{{ translatedNumber($category->position_order) }}</td>
                                                <td>
                                                    <div>
                                                        <img style="width: 70px !important;"
                                                             src="@if (isset($category->image)) {{ url(@$category->image) }} @endif"
                                                             alt="" class="img img-responsive m-2">
                                                    </div>
                                                </td>


                                                <td class="nowrap">
                                                    <x-backend.status :id="$category->id" :status="$category->status"
                                                                      :route="'store.category.status'">
                                                    </x-backend.status>

                                                </td>

                                                <td>
                                                    <div class="dropdown CRM_dropdown">
                                                        <button class="btn btn-secondary dropdown-toggle" type="button"
                                                                id="dropdownMenu1{{ @$category->id }}"
                                                                data-bs-toggle="dropdown"
                                                                aria-haspopup="true" aria-expanded="false">
                                                            {{ __('common.Select') }}
                                                        </button>
                                                        <div class="dropdown-menu dropdown-menu-right"
                                                             aria-labelledby="dropdownMenu1{{ @$category->id }}">
                                                            @if (permissionCheck('store.category.edit'))
                                                                <a class="dropdown-item edit_brand"
                                                                   href="{{ route('store.category.edit', $category->id) }}">{{ __('common.Edit') }}</a>
                                                            @endif
                                                            @if (permissionCheck('store.category.destroy'))
                                                                <a onclick="confirm_modal('{{ route('store.category.destroy', $category->id) }}');"
                                                                   class="dropdown-item edit_brand">{{ __('common.Delete') }}</a>
                                                            @endif
                                                        </div>
                                                    </div>
                                                </td>
                                            </tr>
                                        @endforeach
                                        </tbody>
                                    </table>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>


    @include('store::partials.delete_modal')

@endsection


@push('scripts')
    <script type="application/javascript">
        (function ($) {
            "use strict";
            dataTableOptions = updateColumnExportOption(dataTableOptions, [0, 1, 2, 3,]);

            $('#lms_table').DataTable(dataTableOptions);

        })(jQuery);
    </script>
@endpush

