<?php

namespace Modules\Store\Http\Controllers;

use App\Http\Controllers\Controller;
use Brian2694\Toastr\Facades\Toastr;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Modules\Store\Services\ProductService;

class ProductImportController extends Controller
{


    public $productService;

    public function __construct(ProductService $productService)
    {

        $this->productService = $productService;
    }


    public function bulk_product_upload_page()
    {
        return view('store::products.bulk_upload');
    }

    public function bulk_product_store(Request $request)
    {
        $rules = [
            'excel_file' => 'required|mimes:xls,xlsx|max:2048'
        ];

        $this->validate($request, $rules, validationMessage($rules));

        DB::beginTransaction();
        try {
            $this->productService->excelUploadProduct($request->except("_token"));
            DB::commit();
            Toastr::success(__('common.Operation successful'), __('common.Success'));
            return back();
        } catch (\Exception $e) {
            DB::rollBack();
            if ($e->getCode() == 23000) {
                Toastr::error(__('product.duplicate_entry_is_exist_in_your_file'));
            } else {
                Toastr::error(__('common.error_message'));
            }

            return back();
        }
    }

    public function headingRow(): int
    {
        return 1;
    }
}
