<?php

namespace Modules\Store\Entities;

use App\Traits\Tenantable;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\Auth;
use App\Traits\HasTranslations;

class ProductUnit extends Model
{
    use HasTranslations, Tenantable;
    public $translatable = ['name'];
    protected $table = "product_units";
    protected $guarded = ["id"];

    public static function boot()
    {
        parent::boot();
        static::created(function ($model) {
            $model->created_by = Auth::user()->id ?? null;
        });

        static::updating(function ($model) {
            $model->updated_by = Auth::user()->id ?? null;
        });
    }
}
