<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;
use Modules\Store\Entities\RefundReason;

class CreateRefundReasonsTable extends Migration
{
    public function up()
    {
        Schema::create('refund_reasons', function (Blueprint $table) {
            $table->id();
            $table->string('reason')->nullable();
            $table->timestamps();
        });

        RefundReason::create(['reason' => 'Product mismatch']);
        RefundReason::create(['reason' => 'Product defective']);
        RefundReason::create(['reason' => 'Order wrong product']);
        RefundReason::create(['reason' => 'Product arrived lately']);
    }

    public function down()
    {
        Schema::dropIfExists('refund_reasons');
    }
}
