<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;
use Modules\Store\Entities\ProductUnit;

class CreateProductUnitsTable extends Migration
{
    public function up()
    {
        Schema::create('product_units', function (Blueprint $table) {
            $table->id();
            $table->longText("name")->nullable();
            $table->text("description")->nullable();
            $table->boolean("status")->default(0);
            $table->unsignedBigInteger("created_by")->nullable();
            $table->foreign("created_by")->on("users")->references("id")->onDelete("cascade");
            $table->unsignedBigInteger("updated_by")->nullable();
            $table->foreign("updated_by")->on("users")->references("id")->onDelete("cascade");
            $table->integer('lms_id')->default(1);
            $table->timestamps();
        });

        $units = [
            [
                'name' => 'Piece (pc)',
                'description' => 'Individual unit of an item.',
                'status' => true,
            ],
            [
                'name' => 'Kilogram (kg)',
                'description' => 'Unit of mass equal to 1,000 grams.',
                'status' => true,
            ],
            [
                'name' => 'Liter (L)',
                'description' => 'Unit of volume equal to 1,000 milliliters.',
                'status' => true,
            ],

            [
                'name' => 'Pack',
                'description' => 'Group of multiple items packaged together.',
                'status' => false,
            ],
            [
                'name' => 'Box',
                'description' => 'Larger container for holding multiple packs.',
                'status' => true,
            ],
        ];

        foreach ($units as $unit) {
            ProductUnit::create($unit);
        }
    }

    public function down()
    {
        Schema::dropIfExists('product_units');
    }
}
