@extends('backend.master')
@push('styles')
    <link rel="stylesheet" href="{{asset('public/backend/css/student_list.css')}}"/>

@endpush

@section('table')
    @php
        $table_name='users';
    @endphp
    {{$table_name}}
@stop
@section('mainContent')

    {!! generateBreadcrumb() !!}

    <section class="admin-visitor-area up_st_admin_visitor">
        <div class="container-fluid p-0">

            <div class=" ">
                <div class="white_box">
                    <form action="{{isset($user)?route('organization.update',$user->id):route('organization.store')}}"
                          method="POST"
                          enctype="multipart/form-data">
                        @csrf
                        <div class="row">
                            <div class="col-xl-12">
                                <div class="primary_input mb-25">
                                    <label class="primary_input_label" for="">{{__('common.Name')}} <strong
                                            class="text-danger">*</strong></label>
                                    <input class="primary_input_field" name="name" placeholder="-"
                                           id="addName"
                                           type="text"
                                           value="{{ old('name',isset($user)?$user->name:'') }}" {{$errors->first('name') ? 'autofocus' : ''}}>
                                </div>
                            </div>

                        </div>
                        <div class="row">
                            <div class="col-xl-12">
                                <div class="primary_input mb-35">
                                    <label class="primary_input_label"
                                           for="">{{__('common.About')}}</label>
                                    <textarea class="lms_summernote" name="about" id="addAbout" cols="30"
                                              rows="10">{{ old('about',isset($user)?$user->about:'') }}</textarea>
                                </div>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-xl-6 d-none">
                                <div class="primary_input mb-15">
                                    <label class="primary_input_label" for="">{{__('common.Date of Birth')}}
                                    </label>
                                    <div class="primary_datepicker_input">
                                        <div class="g-0  input-right-icon">
                                            <div class="col">
                                                <div class="">
                                                    <input placeholder="{{__('common.Date')}}"
                                                           class="primary_input_field primary-input date form-control"
                                                           id="" type="text" name="dob"
                                                           value="{{old('dob',isset($user)?$user->dob:'')}}"
                                                           {{$errors->first('dob') ? 'autofocus' : ''}}
                                                           autocomplete="off">
                                                </div>
                                            </div>
                                            <button class="" type="button">
                                                <i class="ti-calendar" id="start-date-icon"></i>
                                            </button>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="col-xl-6">
                                <div class="primary_input mb-25">
                                    <label class="primary_input_label"
                                           for="">{{__('common.Phone')}} </label>
                                    <input class="primary_input_field"
                                           value="{{old('phone',isset($user)?$user->phone:'')}}" name="phone"
                                           id="addPhone"
                                           placeholder="-" {{$errors->first('phone') ? 'autofocus' : ''}}
                                           type="number">
                                </div>
                            </div>


                            <div class="col-xl-6">
                                <div class="primary_input mb-25">
                                    <label class="primary_input_label" for="">{{__('common.Email')}} <strong
                                            class="text-danger">*</strong></label>
                                    <input class="primary_input_field" name="email" placeholder="-"
                                           id="addEmail"
                                           value="{{old('email',isset($user)?$user->email:'')}}"
                                           {{$errors->first('email') ? 'autofocus' : ''}}
                                           type="email">
                                </div>
                            </div>
                            <div class="col-xl-6">
                                <div class="mb-35">

                                    <x-upload-file
                                        media_id="{{isset($user)?$user->image_media?->media_id:''}}"
                                        name="image"
                                        type="image"
                                        label="{{ __('common.Image') }}"
                                        note="{{__('student.Recommended size')}} {{translatedNumber('330x400')}}"/>
                                </div>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-xl-6">
                                <div class="primary_input mb-25">
                                    <label class="primary_input_label" for="">{{__('common.Password')}}
                                        <strong
                                            class="text-danger">*</strong></label>
                                    <div class="input-group mb-2 mr-sm-2">
                                        <div class="input-group-prepend">
                                            <div class="input-group-text"><i style="cursor:pointer;"
                                                                             class="fas fa-eye-slash eye toggle-password"></i>
                                            </div>
                                        </div>
                                        <input type="password" class="form-control primary_input_field"
                                               id="addPassword" name="password"
                                               autocomplete="new-password"
                                               placeholder="{{__('common.Minimum 8 characters')}}" {{$errors->first('password') ? 'autofocus' : ''}}>
                                    </div>
                                </div>
                            </div>
                            <div class="col-xl-6">
                                <div class="primary_input mb-25">
                                    <label class="primary_input_label"
                                           for="">{{__('common.Confirm Password')}} <strong
                                            class="text-danger">*</strong></label>
                                    <div class="input-group mb-2 mr-sm-2">
                                        <div class="input-group-prepend">
                                            <div class="input-group-text"><i style="cursor:pointer;"
                                                                             class="fas fa-eye-slash eye toggle-password"></i>
                                            </div>
                                        </div>
                                        <input type="password" class="form-control primary_input_field"
                                               {{$errors->first('password_confirmation') ? 'autofocus' : ''}}
                                               id="addCpassword" name="password_confirmation"
                                               placeholder="{{__('common.Minimum 8 characters')}}">
                                    </div>
                                    {{--                                                    <input class="primary_input_field"  name="password_confirmation" placeholder="-" type="text">--}}
                                </div>
                            </div>
                        </div>
                        <div class="row">

                            <div class="col-xl-6">
                                <div class="primary_input mb-25">
                                    <label class="primary_input_label"
                                           for=""> {{__('common.Facebook URL')}}</label>
                                    <input class="primary_input_field" name="facebook" placeholder="-"
                                           id="addFacebook"
                                           type="text" value="{{ old('facebook',isset($user)?$user->facebook:'') }}">
                                </div>
                            </div>
                            <div class="col-xl-6">
                                <div class="primary_input mb-25">
                                    <label class="primary_input_label"
                                           for=""> {{__('common.Twitter URL')}}</label>
                                    <input class="primary_input_field" name="twitter" placeholder="-"
                                           id="addTwitter"
                                           type="text" value="{{ old('twitter',isset($user)?$user->twitter:'') }}">
                                </div>
                            </div>
                        </div>
                        <div class="row">

                            <div class="col-xl-6">
                                <div class="primary_input mb-25">
                                    <label class="primary_input_label"
                                           for=""> {{__('common.LinkedIn URL')}}</label>
                                    <input class="primary_input_field" name="linkedin" placeholder="-"
                                           id="addLinkedin"
                                           type="text" value="{{ old('linkedin',isset($user)?$user->linkedin:'') }}">
                                </div>
                            </div>
                            <div class="col-xl-6">
                                <div class="primary_input mb-25">
                                    <label class="primary_input_label"
                                           for=""> {{__('common.Instagram URL')}}</label>
                                    <input class="primary_input_field" name="instagram" placeholder="-"
                                           id="addInstagram"
                                           type="text" value="{{ old('instagram',isset($user)?$user->instragram:'') }}">
                                </div>
                            </div>
                        </div>

                        <div class="col-lg-12 text-center  ">
                            <div class="d-flex justify-content-center">
                                <button class="primary-btn semi_large2  fix-gr-bg" id="save_button_parent"
                                        type="submit"><i
                                        class="ti-check"></i> {{isset($user)?__('common.Update'):__('common.Save')}} {{__('organization.organization')}}
                                </button>
                            </div>
                        </div>
                    </form>
                </div>
            </div>

        </div>
    </section>

@endsection

@push('scripts')

    <script src="{{asset('public/backend/js/organization_list.js')}}"></script>
@endpush


