<?php

use Illuminate\Support\Facades\Route;
use Modules\Installment\Http\Controllers\InstallmentController;
use Modules\Installment\Http\Controllers\InstallmentSettingController;
use Modules\Installment\Http\Controllers\StudentInstallmentController;
use Modules\Installment\Http\Controllers\InstallmentPurchaseController;
use Modules\Installment\Http\Controllers\InstallmentAdminPurchaseController;


Route::prefix('installment')->middleware(['auth'])->as('installment.')->group(function () {

    Route::group(['middleware' => ['admin']], function () {
        Route::get('/plan', [InstallmentController::class, 'index'])->name('plan.list')->middleware('RoutePermissionCheck:installment.plan.list');
        Route::get('/plan/create', [InstallmentController::class, 'create'])->name('plan.create')->middleware('RoutePermissionCheck:installment.plan.create');
        Route::post('/plan/create', [InstallmentController::class, 'store'])->name('plan.store')->middleware('RoutePermissionCheck:installment.plan.create');
        Route::get('/plan/edit/{plan_id}', [InstallmentController::class, 'edit'])->name('plan.edit')->middleware('RoutePermissionCheck:installment.plan.edit');
        Route::post('/plan/update', [InstallmentController::class, 'update'])->name('plan.update')->middleware('RoutePermissionCheck:installment.plan.edit');
        Route::post('/plan/delete', [InstallmentController::class, 'destroy'])->name('plan.delete')->middleware('RoutePermissionCheck:installment.plan.delete');

        Route::get('/purchase', [InstallmentAdminPurchaseController::class, 'index'])->name('purchase.list')->middleware('RoutePermissionCheck:installment.purchase.list');
        Route::get('/purchase-load', [InstallmentAdminPurchaseController::class, 'purchaseAjax'])->name('purchase.list_ajax');
        Route::get('/purchase/details/{purchase_request}', [InstallmentAdminPurchaseController::class, 'PurchaseRequestDetails'])->name('purchase.details')->middleware('RoutePermissionCheck:installment.purchase.details');
        Route::post('/purchase/change_status', [InstallmentAdminPurchaseController::class, 'PurchaseRequestChangeStatus'])->name('purchase.change_status')->middleware('RoutePermissionCheck:installment.purchase.change_status');
        Route::post('/purchase/reject-request', [InstallmentAdminPurchaseController::class, 'PurchaseRequestRejectRequest'])->name('purchase.reject_request')->middleware('RoutePermissionCheck:installment.purchase.change_status');

        Route::get('/settings', [InstallmentSettingController::class, 'index'])->name('settings')->middleware('RoutePermissionCheck:installment.settings');
        Route::post('/settings', [InstallmentSettingController::class, 'update'])->name('settings.update')->middleware('RoutePermissionCheck:installment.settings');

        Route::get('/overdue', [InstallmentController::class, 'overDue'])->name('overdue_history')->middleware('RoutePermissionCheck:installment.overdue_history');
        Route::get('/overdue-ajax', [InstallmentController::class, 'overDueLoad'])->name('overdue_history_ajax');
        Route::get('sent-reminder/{purchase_id}', [InstallmentController::class, 'sentReminder'])->name('sent_reminder')->middleware('RoutePermissionCheck:installment.sent_reminder');


        Route::get('/verified-users', [InstallmentController::class, 'verifiedUsers'])->name('verified_users')->middleware('RoutePermissionCheck:installment.verified_users');
        Route::get('/verified-users-ajax', [InstallmentController::class, 'verifiedUsersLoad'])->name('verified_users_ajax');
        Route::get('/user-installments/{user_id}', [InstallmentController::class, 'userInstallments'])->name('user_installments');

    });

    Route::get('/purchase/{topic_id}/{plan_id}', [InstallmentPurchaseController::class, 'purchase'])->name('purchase');
    Route::post('/purchase/request', [InstallmentPurchaseController::class, 'submitRequest'])->name('submit_request');


    Route::get('/my-installment', [StudentInstallmentController::class, 'installmentList'])->name('student_installment.list');
    Route::get('/purchase-details/{purchase_request}', [StudentInstallmentController::class, 'PurchaseRequestDetails'])->name('student_installment.purchase_request_details');
    Route::get('/pay-installment/{installment_payment_id}', [StudentInstallmentController::class, 'payInstallment'])->name('student_installment.pay_installment');


});
