@extends('backend.master')
@section('mainContent')
    {!! generateBreadcrumb() !!}

    <section class="admin-visitor-area up_st_admin_visitor">
        <div class="container-fluid p-0">
            <div class="white-box">
                <div class="row">
                    <div class="col-lg-12">

                        <div class="main-title d-md-flex justify-content-md-between mb-20">
                            <h3 class="mb-0 mr-30 mb_xs_15px mb_sm_20px" id="page_title">{{ $data['title'] }}</h3>
                            <ul class="d-flex">
                                <li>
                                    <a class="primary-btn radius_30px fix-gr-bg"
                                       href="{{ route('installment.plan.create') }}"><i
                                            class="ti-plus"></i>{{ _trans('installment.Add Plan') }} </a>
                                </li>
                            </ul>

                        </div>

                        <div class="QA_section QA_section_heading_custom check_box_table">
                            <div class="QA_table ">
                                <div class="">
                                    <table id="lms_table" class="table Crm_table_active3">
                                        <thead>
                                        <tr>
                                            @foreach ($data['table_columns'] as $th)
                                                <th scope="col">{{ $th }}</th>
                                            @endforeach
                                        </tr>
                                        </thead>
                                        <tbody>
                                        @foreach ($data['plans'] as $key => $plan)
                                            <tr>
                                                <th>{{ $key + 1 }}</th>

                                                <td>{{ @$plan->getTranslation('title', auth()->user()->language_code ?? 'en') }}</td>
                                                <td>{{ @$plan->sales ?? 0 }}</td>
                                                <td>
                                                    @php
                                                        $upfront = @$plan->paymentSteps->where('payment_title', 'Upfront')->first();
                                                    @endphp
                                                    {{ $upfront->amount_type == 'percent' ? $upfront->payment_amount . '%' : getPriceFormat($upfront->payment_amount) }}
                                                </td>
                                                <td>
                                                    {{ $plan->paymentSteps->count() > 1 ? $plan->paymentSteps->count() - 1 : 0 }}
                                                </td>
                                                <td>
                                                    @php
                                                        $installment_amount = $plan->paymentSteps->where('payment_title', '!=', 'Upfront')->sum('payment_amount');
                                                    @endphp
                                                    {{ $upfront->amount_type == 'percent' ? $installment_amount . '%' : getPriceFormat($installment_amount) }}
                                                </td>
                                                <td>
                                                    {{ @$plan->capacity }}
                                                </td>
                                                <td>{{ showDate($plan->start_datetime) . ' | ' . showTime($plan->start_datetime) }}
                                                </td>
                                                <td>{{ $plan->end_datetime != null ? showDate($plan->end_datetime) . ' | ' . showTime($plan->end_datetime) : '-' }}
                                                </td>
                                                <td>
                                                    {{ $plan->statusText }}
                                                </td>
                                                <td>
                                                    <div class="dropdown CRM_dropdown">
                                                        <button class="btn btn-secondary dropdown-toggle" type="button"
                                                                id="dropdownMenu2" data-bs-toggle="dropdown"
                                                                aria-haspopup="true"
                                                                aria-expanded="false">
                                                            {{ __('common.Select') }}
                                                        </button>
                                                        <div class="dropdown-menu dropdown-menu-right"
                                                             aria-labelledby="dropdownMenu2">
                                                            @if (permissionCheck('installment.plan.edit'))
                                                                <a class="dropdown-item edit_brand"
                                                                   href="{{ route('installment.plan.edit', @$plan->id) }}">{{ _trans('common.Edit') }}</a>
                                                            @endif
                                                            @if (permissionCheck('installment.plan.delete'))
                                                                <a class="dropdown-item" data-bs-toggle="modal"
                                                                   data-bs-target="#deleteQuestionGroupModal{{ @$plan->id }}"
                                                                   href="#">{{ __('common.Delete') }}</a>
                                                            @endif

                                                        </div>
                                                    </div>
                                                </td>
                                            </tr>

                                            <div class="modal fade admin-query"
                                                 id="deleteQuestionGroupModal{{ $plan->id }}">
                                                <div class="modal-dialog modal-dialog-centered">
                                                    <div class="modal-content">
                                                        <div class="modal-header">
                                                            <h4 class="modal-title">{{ __('common.Delete') }}
                                                                {{ _trans('installment.Installment') }}
                                                                {{ _trans('installment.Plan') }}</h4>
                                                            <button type="button" class="btn-close"
                                                                    data-bs-dismiss="modal"><i
                                                                    class="ti-close "></i></button>
                                                        </div>

                                                        <div class="modal-body">
                                                            <div class="text-center">
                                                                <h4> {{ __('common.Are you sure to delete ?') }}</h4>
                                                            </div>

                                                            <div class="mt-40 d-flex justify-content-between">
                                                                <button type="button" class="primary-btn tr-bg"
                                                                        data-bs-dismiss="modal">{{ __('common.Cancel') }}</button>


                                                                <form method="POST"
                                                                      action="{{ route('installment.plan.delete') }}"
                                                                      enctype="multipart/form-data">
                                                                    @csrf
                                                                    <input type="hidden" name="id"
                                                                           value="{{ $plan->id }}">
                                                                    <button class="primary-btn fix-gr-bg"
                                                                            type="submit">{{ __('common.Delete') }}</button>
                                                                </form>

                                                            </div>
                                                        </div>

                                                    </div>
                                                </div>
                                            </div>
                                        @endforeach
                                        </tbody>
                                    </table>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
    <input type="hidden" name="status_route" class="status_route" value="{{ route('coupons.status_update') }}">

    @include('backend.partials.delete_modal')
@endsection
@push('scripts')
    <script type="application/javascript">
        (function ($) {
            "use strict";

            dataTableOptions = updateColumnExportOption(dataTableOptions, [0, 1, 2, 3, 4, 5, 6, 7, 8]);

            $('#lms_table').DataTable(dataTableOptions);

        })(jQuery);

    </script>
@endpush
