<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateInstallmentPlansTable extends Migration
{
    public function up()
    {
        Schema::create('installment_plans', function (Blueprint $table) {
            $table->id();
            $table->text('title');
            $table->longText('description')->nullable();
            $table->string('banner')->nullable();
            $table->integer('capacity')->nullable();
            $table->integer('sales')->nullable()->default(0);
            $table->timestamp('start_datetime')->nullable();
            $table->timestamp('end_datetime')->nullable();

            $table->integer('verification_required')->nullable()->default(0)->comment('0=No, 1=Yes');
            $table->longText('verification_description')->nullable();
            $table->string('verification_banner')->nullable();
            $table->string('verification_video')->nullable();

            $table->integer('request_uploads')->nullable()->default(0)->comment('0=No, 1=Yes');
            $table->integer('bypass_verification_for_verified_users')->nullable()->default(0)->comment('0=No, 1=Yes');

            $table->integer('status')->nullable()->default(1)->comment('1=Active, 2=Inactive');

            $table->softDeletes();
            $table->timestamps();
        });
    }


    public function down()
    {
        Schema::dropIfExists('installment_plans');
    }
}
