@php use Carbon\Carbon; @endphp
@extends('backend.master')
@push('styles')
    <link rel="stylesheet" href="{{ asset('public/backend/css/class.css') }}"/>
@endpush
@php
    $table_name = 'courses';
@endphp
@section('table')
    {{ $table_name }}
@stop
@section('mainContent')

    {!! generateBreadcrumb() !!}
    <section class="admin-visitor-area up_st_admin_visitor">


        <div class="white_box mb_30  student-details header-menu">
            <div class="white_box_tittle list_header main-title mb-10">
                <h3 class="mb-0"> {{ $data['title']}}</h3>
            </div>
            <div class="col-lg-12">


                <input type="hidden" id="url" value="{{ url('/') }}">
                @php
                    $LanguageList = getLanguageList();
                    $target_item = isset($data['rule']) ? (isset($data['rule']->rule_specific_item) ? $data['rule']->rule_specific_item->rule_specific_item_details():[]) : [];
                @endphp
                @if (isset($data['rule']))
                    <form action="{{ route('cashback.rules.update') }}" method="post" id="plan_save_form"
                          enctype="multipart/form-data">
                        <input type="text" hidden name="id" value="{{$data['rule']->id}}">
                        @else
                            <form action="{{ route('cashback.rules.store') }}" method="post" id="plan_save_form"
                                  enctype="multipart/form-data">
                                @endif
                                @csrf
                                <div class="row pt-0">
                                    @if (isModuleActive('FrontendMultiLang'))
                                        <ul class="nav nav-tabs no-bottom-border  mt-sm-md-20 mb-10 ms-3"
                                            role="tablist">
                                            @foreach ($LanguageList as $key => $language)
                                                <li class="nav-item">
                                                    <a class="nav-link  @if (auth()->user()->language_code == $language->code) active @endif"
                                                       href="#element{{ $language->code }}" role="tab"
                                                       data-bs-toggle="tab">{{ $language->native }} </a>
                                                </li>
                                            @endforeach
                                        </ul>
                                    @endif
                                </div>
                                <div class="tab-content">
                                    @foreach ($LanguageList as $key => $language)
                                        <div role="tabpanel"
                                             class="tab-pane fade @if (auth()->user()->language_code == $language->code) show active @endif  "
                                             id="element{{ $language->code }}">
                                            <div class="row">

                                                <div class="col-xl-12">
                                                    <div class="primary_input mb-25">
                                                        <label class="primary_input_label d-flex"
                                                               for="">{{ _trans('cashback.Rule') }}
                                                            {{ __('common.Title') }} <span class="text-danger"> *</span>
                                                        </label>

                                                        <input class="primary_input_field"
                                                               name="title[{{ $language->code }}]"
                                                               placeholder="-" id="addTitle" type="text"
                                                               {{ $errors->has('title') ? 'autofocus' : '' }}
                                                               value="{{ isset($data['rule']) ? $data['rule']->getTranslation('title', $language->code) : '' }}">
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    @endforeach
                                </div>
                                <div class="row mb-20">
                                    <div class="col-lg-3">
                                        <div class="primary_input">
                                            <label class="primary_input_label" for="">{{ __('coupons.Start Date') }}
                                                <span class="text-danger">*</span></label>
                                            <div class="primary_datepicker_input">
                                                <div class="g-0  input-right-icon">
                                                    <div class="col">
                                                        <div class="">
                                                            <input placeholder="{{ __('coupons.Start Date') }}"
                                                                   class="primary_input_field primary-input date form-control  {{ @$errors->has('start_date') ? ' is-invalid' : '' }}"
                                                                   id="start_date" type="text" name="start_date"
                                                                   value="{{ isset($data['rule']) ? getJsDateFormat(\Carbon\Carbon::parse($data['rule']->start_datetime)->format(getActivePhpDateFormat())) : getJsDateFormat(date('m/d/Y')) }}"
                                                                   autocomplete="off">

                                                        </div>
                                                    </div>
                                                    <button class="" type="button">
                                                        <i class="ti-calendar" id="start-date-icon"></i>
                                                    </button>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-lg-3">
                                        <label class="primary_input_label">{{ _trans('cashback.Start Time') }} <span
                                                class="text-danger">*</span></label>
                                        <div class="primary_input">
                                            <input required
                                                   class="primary-input primary_input_field  time form-control{{ @$errors->has('start_time') ? ' is-invalid' : '' }}"
                                                   type="text" name="start_time"
                                                   value="{{ isset($data['rule']) ? showTime($data['rule']->start_datetime) : old('start_time') }}">
                                        </div>
                                    </div>
                                    <div class="col-lg-3">
                                        <div class="primary_input">
                                            <label class="primary_input_label"
                                                   for="">{{ _trans('cashback.End Date') }}<span
                                                    class="text-danger">*</span></label>
                                            <div class="primary_datepicker_input">
                                                <div class="g-0  input-right-icon">
                                                    <div class="col">
                                                        <div class="">
                                                            <input placeholder="{{ _trans('cashback.End Date') }}"
                                                                   required
                                                                   class="primary_input_field primary-input date form-control  {{ @$errors->has('end_date') ? ' is-invalid' : '' }}"
                                                                   id="end_date" type="text" name="end_date"
                                                                   value="{{ isset($data['rule']->end_datetime) ? getJsDateFormat(Carbon::parse($data['rule']->end_datetime)->format(getActivePhpDateFormat())) : '' }}"
                                                                   autocomplete="off">

                                                        </div>
                                                    </div>
                                                    <button class="" type="button">
                                                        <i class="ti-calendar" id="start-date-icon"></i>
                                                    </button>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-lg-3">
                                        <label class="primary_input_label">{{ _trans('cashback.End Time') }}<span
                                                class="text-danger">*</span></label>
                                        <div class="primary_input">
                                            <input required
                                                   class="primary-input primary_input_field  time form-control{{ @$errors->has('end_time') ? ' is-invalid' : '' }}"
                                                   type="text" name="end_time"
                                                   value="{{ isset($data['rule']->end_datetime) ? showTime($data['rule']->end_datetime) : old('end_time') }}">
                                        </div>
                                    </div>
                                </div>
                                <h3>
                                    {{ _trans('cashback.Users') }}
                                </h3>
                                <div class="row">
                                    <div class="col-lg-4">
                                        <div class="primary_input mb-35">
                                            <label class="primary_input_label" for="">{{ _trans('cashback.User Type') }}
                                                <span class="text-danger">*</span>
                                            </label>

                                            <select class="primary_select" name="user_type" id="select_user_type">
                                                <option data-display="{{ _trans('cashback.User Type') }}" value="">
                                                    {{ _trans('common.Select') }} {{ _trans('cashback.User Type') }}</option>
                                                <option value="all"
                                                    {{ isset($data['rule']) ? ($data['rule']->user_type == 'all' ? 'selected' : '') : '' }}>
                                                    {{ _trans('cashback.All User') }} </option>
                                                <option value="specific_user"
                                                    {{ isset($data['rule']) ? ($data['rule']->user_type == 'specific_user' ? 'selected' : '') : '' }}>
                                                    {{ _trans('cashback.Specific User') }} </option>

                                            </select>
                                        </div>
                                    </div>
                                    <div class="col-xl-4" id="specific_user_section" style="display:none">
                                        <div class="primary_input mb-25">
                                            <label class="primary_input_label" for="specific_user_select"
                                                   id="specic_user_lebel">
                                                {{_trans('cashback.Select Users')}}
                                            </label>
                                            <select name="specific_user[]" id="specific_user_select"
                                                    class="multypol_check_select active mb-15 e1" multiple>
                                                @foreach ($data['students'] as $student)
                                                    <option value="{{ $student->id }}"
                                                        {{ isset($data['rule']) ? ($data['rule']->users->where('user_id', $student->id)->count() > 0 ? 'selected' : '') : '' }}>
                                                        {{ $student->name }}</option>

                                                @endforeach
                                            </select>
                                        </div>
                                    </div>
                                </div>
                                <h3 class="mt-20">
                                    {{ _trans('cashback.Target Products') }}
                                </h3>
                                <div class="row">
                                    <div class="col-lg-4">
                                        <div class="primary_input mb-35">
                                            <label class="primary_input_label"
                                                   for="">{{ _trans('cashback.Target Type') }} <span
                                                    class="text-danger">*</span>
                                            </label>

                                            <select class="primary_select" name="target_type" id="select_target_type">
                                                <option data-display="{{ _trans('cashback.Target Type') }}" value="">
                                                    {{ _trans('cashback.Target Type') }} </option>
                                                <option value="all"
                                                    {{ isset($data['rule']) ? ($data['rule']->rule_specific_item->target_type == 'all' ? 'selected' : '') : '' }}>
                                                    {{ _trans('cashback.All Type') }} </option>
                                                <option value="course"
                                                    {{ isset($data['rule']) ? ($data['rule']->rule_specific_item->target_type == 'course' ? 'selected' : '') : '' }}>
                                                    {{ _trans('cashback.Course') }} </option>
                                                <option value="quiz"
                                                    {{ isset($data['rule']) ? ($data['rule']->rule_specific_item->target_type == 'quiz' ? 'selected' : '') : '' }}>
                                                    {{ _trans('cashback.Quiz') }} </option>
                                                <option value="live_class"
                                                    {{ isset($data['rule']) ? ($data['rule']->rule_specific_item->target_type == 'live_class' ? 'selected' : '') : '' }}>
                                                    {{ _trans('cashback.Live Class') }} </option>
                                                <option value="recharge"
                                                    {{ isset($data['rule']) ? ($data['rule']->rule_specific_item->target_type == 'recharge' ? 'selected' : '') : '' }}>
                                                    {{ _trans('cashback.Recharge Wallet') }} </option>
                                                @if(isModuleActive('Gift'))
                                                    <option value="gift"
                                                        {{ isset($data['rule']) ? ($data['rule']->rule_specific_item->target_type == 'gift' ? 'selected' : '') : '' }}>
                                                        {{ _trans('cashback.Gift') }} </option>
                                                @endif
                                                @if(isModuleActive('UpcomingCourse'))
                                                    <option value="upcoming_course"
                                                        {{ isset($data['rule']) ? ($data['rule']->rule_specific_item->target_type == 'upcoming_course' ? 'selected' : '') : '' }}>
                                                        {{ _trans('cashback.Upcoming Course') }} </option>
                                                @endif
                                                @if(isModuleActive('Subscription'))
                                                    <option value="subscription"
                                                        {{ isset($data['rule']) ? ($data['rule']->rule_specific_item->target_type == 'subscription' ? 'selected' : '') : '' }}>
                                                        {{ _trans('cashback.Subscription') }} </option>
                                                @endif
                                            </select>
                                        </div>
                                    </div>
                                    <div class="col-lg-4" id="target_options" style="display: none">
                                        <div class="primary_input mb-35">
                                            <label class="primary_input_label"
                                                   for="">{{ _trans('cashback.Select Target') }}
                                                <span
                                                    class="text-danger">*</span>
                                            </label>

                                            <select class="primary_select" name="target" id="target_item_options">
                                            </select>
                                        </div>
                                    </div>
                                    <div class="col-xl-4" id="specific_section" style="display:none">
                                        <div class="primary_input mb-25">
                                            <label class="primary_input_label" for="specific_item_select"
                                                   id="specic_item_lebel">
                                            </label>
                                            <select name="specific_item[]" id="specific_item_select"
                                                    class="multypol_check_select active mb-15 e1" multiple>

                                            </select>
                                        </div>
                                    </div>
                                </div>

                                <div class="row mt-20">
                                    <div class="col-lg-4">
                                        <div class="primary_input mb-25">
                                            <label class="primary_input_label d-flex" for="min_purchase_amount">
                                                {{ _trans('cashback.Minimum Purchase Amount') }} <span
                                                    class="text-danger">*</span></label>
                                            <input class="primary_input_field" name="min_purchase_amount"
                                                   placeholder="-" id="min_purchase_amount"
                                                   type="number"
                                                   {{ $errors->has('min_purchase_amount') ? 'autofocus' : '' }}
                                                   value="{{ @$data['rule']->min_purchase_amount }}">
                                        </div>
                                    </div>

                                    <div class="col-lg-4">
                                        <div class="primary_input mb-35">
                                            <label class="primary_input_label"
                                                   for="">{{ _trans('cashback.Apply cashback per item') }}</label>

                                            <label class="switch_toggle" for="checkbox_per_item_check"
                                                   style="margin: 10px 80px ;">
                                                <input type="checkbox" id="checkbox_per_item_check"
                                                       name="apply_cashback_per_item"
                                                       {{ isset($data['rule']) ? ($data['rule']->apply_cashback_per_item == 1 ? 'checked' : '') : '' }}
                                                       value="1">
                                                <i class="slider round"></i>
                                            </label>
                                        </div>
                                    </div>
                                    <div class="col-lg-4">
                                        <div class="primary_input mb-35">
                                            <label class="primary_input_label" for="">{{ _trans('cashback.Status') }}
                                                <span class="text-danger">*</span>
                                            </label>

                                            <select class="primary_select" name="status">
                                                <option data-display="{{ _trans('cashback.Status') }}" value="">
                                                    {{ _trans('cashback.Status') }} </option>
                                                <option
                                                    value="1" {{ isset($data['rule']) ? ($data['rule']->status == 1 ? 'selected' : '') : 'selected' }}>
                                                    {{ _trans('cashback.Active') }} </option>
                                                <option
                                                    value="0" {{ isset($data['rule']) ? ($data['rule']->status == 0 ? 'selected' : '') : '' }} >
                                                    {{ _trans('cashback.Deactivate') }} </option>
                                            </select>
                                        </div>
                                    </div>
                                </div>
                                <h3>{{ _trans('cashback.Payment') }} </h3>
                                <div class="row">
                                    <div class="col-lg-6">
                                        <div class="primary_input mb-25">
                                            <label class="primary_input_label d-flex" for="amount">
                                                {{ _trans('cashback.Amount') }} <span
                                                    class="text-danger">*</span></label>
                                            <input class="primary_input_field" name="amount" placeholder="-" id="amount"
                                                   type="number" {{ $errors->has('amount') ? 'autofocus' : '' }}
                                                   value="{{ @$data['rule']->amount }}">
                                        </div>
                                    </div>

                                    <div class="col-lg-6">
                                        <div class="primary_input mb-35">
                                            <label class="primary_input_label"
                                                   for="">{{ _trans('cashback.Amount Type') }} <span
                                                    class="text-danger">*</span></label>

                                            <select class="primary_select" name="amount_type">
                                                <option data-display="{{ _trans('cashback.Amount Type') }}" value="">
                                                    {{ _trans('cashback.Amount Type') }} </option>
                                                <option
                                                    value="fixed_amount" {{ isset($data['rule']) ? ($data['rule']->amount_type == 'fixed_amount' ? 'selected' : '') : '' }}> {{ _trans('cashback.Fixed Amount') }} </option>
                                                <option
                                                    value="percent" {{ isset($data['rule']) ? ($data['rule']->amount_type == 'percent' ? 'selected' : '') : '' }} >{{ _trans('cashback.Percent') }} </option>
                                            </select>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-lg-12 text-center pt_15">
                                    <div class="d-flex justify-content-center">
                                        <button class="primary-btn semi_large2  fix-gr-bg" id="save_plan_button"
                                                type="submit"><i
                                                class="ti-check"></i> {{ isset($data['rule']) ? __('common.Update') : __('common.Add') }} {{ _trans('cashback.Rule') }}
                                        </button>
                                    </div>
                                </div>
                            </form>
            </div>
        </div>

    </section>

@endsection
@push('js')
    <script>
        (function ($) {
            "use strict";
            $(document).ready(function () {
                $("#select_user_type").change(function () {
                    let user_type = $(this).val();
                    let specific_user_section = $('#specific_user_section');
                    if (user_type == 'specific_user') {
                        specific_user_section.fadeIn();
                    } else {
                        specific_user_section.fadeOut();
                    }

                });
            });
            $('#add_new_feature').on('click', function (e) {
                e.preventDefault();
                var html = `<div class="row">
                        <div class="col-lg-6" >
                            <div class="primary_input mb-25">
                                <input class="primary_input_field" name="features[]" placeholder="-" id="addCapacity" type="text" value="">
                            </div>
                        </div>
                        <div class="col-lg-4 mt_10">
                            <button type="button" class="primary-btn icon-only fix-gr-bg removePlanFeature"><span class="ti-trash pe-2"></span></button>
                        </div>
                    </div>`;
                $('#feature_list').append(html);
            });
            $('#add_new_step').on('click', function (e) {
                e.preventDefault();
                var index = $('#payment_step_list').children().length + 1; // Get the current number of steps and increment by 1
                var html = `<div class="row">
                            <div class="col-lg-6">
                                <div class="primary_input mb-25">
                                    <label class="primary_input_label d-flex" for="payment_title"> {{ _trans('cashback.Title') }} <span class="text-danger">*</span></label>
                                    <input class="primary_input_field payment_steps" name="payment_steps[${index}][payment_title]" placeholder="-" id="payment_title_${index}" type="text" value="">
                                </div>
                            </div>
                            <div class="col-lg-2">
                                <div class="primary_input mb-25">
                                    <label class="primary_input_label d-flex" for="payment_deadline"> {{ _trans('cashback.Deadline') }} <span class="text-danger">*</span></label>
                                    <input class="primary_input_field payment_steps" name="payment_steps[${index}][payment_deadline]" placeholder="-" id="payment_deadline" type="number" value="">
                                </div>
                            </div>
                            <div class="col-lg-2">
                                <div class="primary_input mb-25">
                                    <label class="primary_input_label d-flex" for="payment_amount"> {{ _trans('cashback.Amount') }} ({{ _trans('cashback.Percent') }}) <span class="text-danger">*</span></label>
                                    <input class="primary_input_field payment_steps step_amount" name="payment_steps[${index}][payment_amount]" placeholder="-" id="payment_amount" type="number" value="">
                                </div>
                            </div>
                            <div class="col-lg-3" style="display:none">
                                <div class="primary_input mb-35">
                                    <label class="primary_input_label" for="">{{ _trans('cashback.Amount Type') }} <span class="text-danger">*</span></label>

                                    <select class="primary_select payment_step_payment_type payment_steps" name="payment_steps[${index}][amount_type]">
                                        <option data-display="{{ _trans('cashback.Amount Type') }}"
                                            value="">{{ _trans('cashback.Amount Type') }} </option>
                                            <option value="fixed_amount">{{ _trans('cashback.Fixed Amount') }} </option>
                                            <option value="percent" selected >{{ _trans('cashback.Percent') }} </option>
                                    </select>
                                </div>
                            </div>
                            <div class="col-lg-2" style="margin-top: 35px;">
                                <button type="button" class="primary-btn icon-only fix-gr-bg removePaymentStep"><span class="ti-trash pe-2"></span></button>
                            </div>
                        </div>`;

                $('#payment_step_list').append(html);
                var notLastElement = $('#payment_step_list').children().not(':last');
                notLastElement.find('.payment_step_payment_type').niceSelect('update');

                $('#payment_step_list').children().last().find('.payment_step_payment_type').niceSelect();
            });

            $(document).on('click', '.removePlanFeature', function (e) {
                e.preventDefault();
                $(this).parent().parent().remove();
            });
            $(document).on('click', '.removePaymentStep', function (e) {
                e.preventDefault();
                $(this).parent().parent().remove();
            });

            function planVerification(el) {
                if ($(el).prop('checked') == true) {
                    $('.varification_section').fadeIn();
                } else {
                    $('.varification_section').fadeOut();
                }
            }

            function handleTargetType() {
                $('#target_item_options').html('');
                if ($(this).val() == 'course') {
                    $('#target_item_options').append(`
                        <option data-display="{{ _trans('cashback.Select Target') }}" value="">{{ _trans('cashback.Select Target') }} </option>
                        <option value="all_course" {{ isset($data['rule']) ? ($data['rule']->rule_specific_item->target == 'all_course' ? 'selected' : '') : '' }}>{{ _trans('cashback.All Course') }} </option>
                        <option value="specific_category" {{ isset($data['rule']) ? ($data['rule']->rule_specific_item->target == 'specific_category' ? 'selected' : '') : '' }}>{{ _trans('cashback.Specific Category') }} </option>
                        <option value="specific_instructor" {{ isset($data['rule']) ? ($data['rule']->rule_specific_item->target == 'specific_instructor' ? 'selected' : '') : '' }}>{{ _trans('cashback.Specific Instructor') }} </option>
                        <option value="specific_course" {{ isset($data['rule']) ? ($data['rule']->rule_specific_item->target == 'specific_course' ? 'selected' : '') : '' }}>{{ _trans('cashback.Specific Course') }} </option>
                    `);
                    $('#target_item_options').niceSelect('update');
                }

                if ($(this).val() == 'upcoming_course') {
                    $('#target_item_options').append(`
                        <option data-display="{{ _trans('cashback.Select Target') }}" value="">{{ _trans('cashback.Select Target') }} </option>
                        <option value="all_course" {{ isset($data['rule']) ? ($data['rule']->rule_specific_item->target == 'all_course' ? 'selected' : '') : '' }}>{{ _trans('cashback.All Course') }} </option>
                        <option value="specific_category" {{ isset($data['rule']) ? ($data['rule']->rule_specific_item->target == 'specific_category' ? 'selected' : '') : '' }}>{{ _trans('cashback.Specific Category') }} </option>
                        <option value="specific_instructor" {{ isset($data['rule']) ? ($data['rule']->rule_specific_item->target == 'specific_instructor' ? 'selected' : '') : '' }}>{{ _trans('cashback.Specific Instructor') }} </option>
                        <option value="specific_course" {{ isset($data['rule']) ? ($data['rule']->rule_specific_item->target == 'specific_course' ? 'selected' : '') : '' }}>{{ _trans('cashback.Specific Course') }} </option>
                    `);
                    $('#target_item_options').niceSelect('update');
                }

                if ($(this).val() == 'quiz') {
                    $('#target_item_options').append(`
                        <option data-display="{{ _trans('cashback.Select Target') }}" value="">{{ _trans('cashback.Select Target') }} </option>
                        <option value="all_quiz" {{ isset($data['rule']) ? ($data['rule']->rule_specific_item->target == 'all_quiz' ? 'selected' : '') : '' }}>{{ _trans('cashback.All Quiz') }} </option>
                        <option value="specific_instructor" {{ isset($data['rule']) ? ($data['rule']->rule_specific_item->target == 'specific_instructor' ? 'selected' : '') : '' }}>{{ _trans('cashback.Specific Instructor') }} </option>
                        <option value="specific_quiz" {{ isset($data['rule']) ? ($data['rule']->rule_specific_item->target == 'specific_quiz' ? 'selected' : '') : '' }}>{{ _trans('cashback.Specific Quiz') }} </option>
                    `);
                    $('#target_item_options').niceSelect('update');
                }

                if ($(this).val() == 'live_class') {
                    $('#target_item_options').append(`
                        <option data-display="{{ _trans('cashback.Select Target') }}" value="">{{ _trans('cashback.Select Target') }} </option>
                        <option value="all_live_class" {{ isset($data['rule']) ? ($data['rule']->rule_specific_item->target == 'all_live_class' ? 'selected' : '') : '' }}>{{ _trans('cashback.All Live Class') }} </option>
                        <option value="specific_instructor" {{ isset($data['rule']) ? ($data['rule']->rule_specific_item->target == 'specific_instructor' ? 'selected' : '') : '' }}>{{ _trans('cashback.Specific Instructor') }} </option>
                        <option value="specific_class" {{ isset($data['rule']) ? ($data['rule']->rule_specific_item->target == 'specific_class' ? 'selected' : '') : '' }}>{{ _trans('cashback.Specific Class') }} </option>
                    `);
                    $('#target_item_options').niceSelect('update');
                }

                if ($(this).val() == 'subscription') {
                    $('#target_item_options').append(`
                        <option data-display="{{ _trans('cashback.Select Target') }}" value="">{{ _trans('cashback.Select Target') }} </option>
                        <option value="all_subscription" {{ isset($data['rule']) ? ($data['rule']->rule_specific_item->target == 'all_subscription' ? 'selected' : '') : '' }}>{{ _trans('cashback.All Subscription') }} </option>
                        <option value="specific_subscription" {{ isset($data['rule']) ? ($data['rule']->rule_specific_item->target == 'specific_subscription' ? 'selected' : '') : '' }}>{{ _trans('cashback.Specific Subscription') }} </option>
                    `);
                    $('#target_item_options').niceSelect('update');
                }

                if ($(this).val() == 'all') {
                    $('#target_options').fadeOut();
                } else if ($(this).val() == 'recharge') {
                    $('#target_options').fadeOut();
                } else if ($(this).val() == 'gift') {
                    $('#target_options').fadeOut();
                } else {
                    $('#target_options').fadeIn();
                }
                $('#specific_section').fadeOut();
            }

            function handleTarget() {
                let selected_value = $(this).val();
                let specific_item_select = $('#specific_item_select');
                let select_target_type = $('#select_target_type').val();
                let specic_item_lebel = $('#specic_item_lebel');
                if (selected_value == 'specific_category') {
                    specific_item_select.html('');
                    @foreach ($data['categories'] as $category)
                    specific_item_select.append(`
                            <option value="{{ $category->id }}" {{ in_array($category->id, $target_item) ? 'selected' : '' }}>{{ $category->name }}</option>
                        `);
                    @endforeach
                    specic_item_lebel.html(`{{ _trans('cashback.Select Category') }}`);
                    $('#specific_section').fadeIn();
                    specific_item_select.attr('name', 'specific_category[]');
                }

                if (selected_value == 'specific_instructor') {
                    specific_item_select.html('');
                    @foreach ($data['instructors'] as $instructor)
                    specific_item_select.append(`
                            <option value="{{ $instructor->id }}" {{ in_array($instructor->id, $target_item) ? 'selected' : '' }} >{{ $instructor->name }}</option>
                        `);
                    @endforeach
                    specic_item_lebel.html(`{{ _trans('cashback.Select Instructor') }}`);
                    $('#specific_section').fadeIn();
                    specific_item_select.attr('name', 'specific_instructor[]');

                }
                if (selected_value == 'specific_course' && select_target_type == 'course') {
                    specific_item_select.html('');
                    @foreach ($data['courses'] as $course)
                    specific_item_select.append(`
                            <option value="{{ $course->id }}" {{ in_array($course->id, $target_item) ? 'selected' : '' }}>{{ $course->getTranslation('title', auth()->user()->language_code) }}</option>
                        `);
                    @endforeach
                    specic_item_lebel.html(`{{ _trans('cashback.Select Course') }}`);
                    $('#specific_section').fadeIn();
                    specific_item_select.attr('name', 'specific_course[]');
                }
                if (selected_value == 'specific_course' && select_target_type == 'upcoming_course') {
                    specific_item_select.html('');
                    @foreach ($data['upcoming_courses'] as $course)
                    specific_item_select.append(`
                            <option value="{{ $course->id }}" {{ in_array($course->id, $target_item) ? 'selected' : '' }}>{{ $course->getTranslation('title', auth()->user()->language_code) }}</option>
                        `);
                    @endforeach
                    specic_item_lebel.html(`{{ _trans('cashback.Select Course') }}`);
                    $('#specific_section').fadeIn();
                    specific_item_select.attr('name', 'specific_course[]');
                }
                if (selected_value == 'specific_quiz') {
                    specific_item_select.html('');
                    @foreach ($data['quizzes'] as $quiz)
                    specific_item_select.append(`
                            <option value="{{ $quiz->id }}" {{ in_array($quiz->id, $target_item) ? 'selected' : '' }}>{{ $quiz->title }}</option>
                        `);
                    @endforeach
                    specic_item_lebel.html(`{{ _trans('cashback.Select Quiz') }}`);
                    $('#specific_section').fadeIn();
                    specific_item_select.attr('name', 'specific_quiz[]');

                }
                if (selected_value == 'specific_class') {
                    specific_item_select.html('');
                    @foreach ($data['live_classes'] as $live_class)
                    specific_item_select.append(`
                            <option value="{{ $live_class->id }}" {{ in_array($live_class->id, $target_item) ? 'selected' : '' }}>{{ $live_class->title }}</option>
                        `);
                    @endforeach
                    specic_item_lebel.html(`{{ _trans('cashback.Select Live Class') }}`);
                    $('#specific_section').fadeIn();
                    specific_item_select.attr('name', 'specific_class[]');
                }
                if (selected_value == 'specific_subscription') {
                    specific_item_select.html('');
                    @foreach ($data['subscription_plans'] as $subscription_plan)
                    specific_item_select.append(`
                            <option value="{{ $subscription_plan->id }}" {{ in_array($subscription_plan->id, $target_item) ? 'selected' : '' }}>{{ $subscription_plan->title }}</option>
                        `);
                    @endforeach
                    specic_item_lebel.html(`{{ _trans('cashback.Select Subscription Plan') }}`);
                    $('#specific_section').fadeIn();
                    specific_item_select.attr('name', 'specific_class[]');
                }
                if (selected_value == 'all_course' || selected_value == 'all_quiz' || selected_value == 'all_live_class' || selected_value == 'gift' || selected_value == 'recharge' || selected_value == 'all_subscription') {
                    $('#specific_section').fadeOut();
                }
                $('select[multiple]').multiselect('reload');
            }

            function checkFeatureValue() {
                let features = $('input[name="features[]"]');
                let process = true;
                features.each(function () {
                    if ($(this).val().trim() == '') {
                        process = false;
                        $(this).css('border', '1px solid red');
                        toastr.error('Please fill all the feature value', 'Error');
                        return false
                    } else {
                        $(this).css('border', '1px solid #eceef4');
                    }
                });
                return process;
            }

            function paymentStepsValue() {
                let payment_steps = $('.payment_steps');
                let process = true;
                payment_steps.each(function (index, value) {
                    if (value != '[object HTMLDivElement]') {
                        var element_value = $(this).val().trim();
                        if (element_value == '') {
                            process = false;
                            $(this).css('border', '1px solid red');
                            toastr.error('Please fill all the payment steps value', 'Error');
                            return false
                        } else {
                            $('.payment_steps').css('border', '1px solid #eceef4');
                        }

                        if (element_value == 'upfront' || element_value == 'Upfront') {
                            process = false;
                            $(this).css('border', '1px solid red');
                            toastr.error("Don't use upfront as payment step title", "Error");
                            return false
                        } else {
                            $('.payment_steps').css('border', '1px solid #eceef4');
                        }
                    }

                });
                return process;
            }

            function paymentAmountValue() {
                let step_amount = $('.step_amount');
                let process = true;
                let total_percentage = 0;
                step_amount.each(function (index, value) {
                    if (value != '[object HTMLDivElement]') {
                        var element_value = $(this).val().trim();
                        total_percentage += parseInt(element_value);
                        if (total_percentage > 100) {
                            process = false;
                            $('.step_amount').css('border', '1px solid red');
                            toastr.error('Total percentage must be 100', 'Error');
                            return false
                        } else {
                            $('.step_amount').css('border', '1px solid #eceef4');
                        }
                    }
                });
                return process;
            }

            $('#save_plan_button').on('click', function (e) {
                e.preventDefault();
                var feature_status = checkFeatureValue();
                var payment_steps_status = paymentStepsValue();
                var payment_amount_status = paymentAmountValue();

                if (!feature_status) {
                    e.preventDefault();
                    return false;
                } else if (!payment_steps_status) {
                    e.preventDefault();
                    return false;
                } else if (!payment_amount_status) {
                    e.preventDefault();
                    return false;
                } else {
                    $("#plan_save_form").submit();
                }
            });

            $('#select_target_type').on('change', handleTargetType);
            $('#target_item_options').on('change', handleTarget);
            $(document).ready(function () {

                $('#select_target_type').trigger('change');
                $('#target_item_options').trigger('change');
                $('#select_user_type').trigger('change');

                planVerification($('#checkbox_varification'));
            });

        })(jQuery);

    </script>
@endpush
