<div class="modal fade admin-query" id="edit_schedule_modal_{{ $teachingInfo->id }}">
    <div class="modal-dialog  modal-dialog-centered">
        <div class="modal-content">
            <div class="modal-header">
                <h4 class="modal-title">{{ __('appointment.Update Schedule') }}</h4>
                <button type="button" class="close " data-bs-dismiss="modal">
                    <i class="ti-close "></i>
                </button>
            </div>

            <div class="modal-body">


                <form action="{{ route('appointment.schedule.update', $teachingInfo->id) }}" method="POST" enctype="multipart/form-data">
                    @csrf
                    @method('PUT')
                <input type="hidden" name="edit_user" id="edit_user_id" value="{{ $user_id }}">


                <div class="row">
                    <div class="col-xl-12">
                        <div class="primary_input">
                            <div class="primary_datepicker_input">
                                <div class="g-0  input-right-icon">
                                    <div class="col">
                                        <div class="">
                                            <label class="primary_input_label"
                                                   for="edit_date_{{ $teachingInfo->id }}">{{ __('appointment.Date') }}</label>
                                            <input id="edit_date_{{ $teachingInfo->id }}"
                                                   class="primary_input_field primary-input date form-control "
                                                   placeholder="{{ __('appointment.Date') }}" type="text"
                                                   name="start_date"
                                                   value="{{ isset($teachingInfo) ? date('m/d/Y', strtotime($teachingInfo->schedule_date)) : date('m/d/Y') }}"
                                                   autocomplete="off">
                                        </div>
                                    </div>
                                    <button class="mt-3" type="button">
                                        <i class="ti-calendar" id="start-date-icon"></i>
                                    </button>
                                </div>
                                @if ($errors->has('date'))
                                    <span class="invalid-feedback d-block mb-10" role="alert">
                                        <strong>{{ @$errors->first('date') }}</strong>
                                    </span>
                                @endif
                            </div>
                        </div>


                    </div>
                </div>
                <div class="row align-items-end row-gap-24 mt-25">
                    <div class="col-xl-6">
                        <label class="primary_input_label" for="category">{{ __('courses.Category') }}</label>
                        <select class="primary_select edit_category_id" name="category"
                                id="edit_category_id_{{ $teachingInfo->id }}"
                            {{ $errors->has('category') ? 'autofocus' : '' }}>
                            <option data-display="{{ __('common.Select') }} {{ __('quiz.Category') }} *" value="">
                                {{ __('common.Select') }} {{ __('quiz.Category') }} </option>
                            @foreach ($categories as $category)
                                <option value="{{ $category->id }}"
                                    {{ isset($teachingInfo) ? ($teachingInfo->category_id == $category->id ? 'selected' : '') : '' }}>
                                    {{ @$category->name }} </option>
                            @endforeach
                        </select>
                    </div>

                    <div class="col-xl-6 courseBox" id="subCategoryDiv">
                        <select class="primary_select edit_sub_category_id" name="sub_category"
                                id="edit_sub_category_id_{{ $teachingInfo->id }}"
                            {{ $errors->has('sub_category') ? 'autofocus' : '' }}>
                            <option data-display="{{ __('common.Select') }} {{ __('courses.Sub Category') }}  "
                                    value="">{{ __('common.Select') }} {{ __('courses.Sub Category') }}
                            @isset($teachingInfo)
                                @foreach ($teachingInfo->category->activeSubcategories as $subCategory)
                                    <option
                                        value="{{ $subCategory->id }}" {{ $subCategory->id == $teachingInfo->category_id}}>{{ $subCategory->name }}</option>
                                    @endforeach
                                    @endisset
                                    </option>
                        </select>
                    </div>
                </div>
                <div class="row mt-25">
                    <div class="col-xl-12">
                        <label class="primary_checkbox d-flex me-2 w-100 move_slot">
                            <input type="checkbox" class="move_slot" id="move_slot_{{ $teachingInfo->id }}"
                                   name="move_slot">
                            <span class="checkmark me-2"></span>{{ __('appointment.Are You Want To Move Slot?') }}
                        </label>
                    </div>
                </div>
                <div class="row mt-25 moveSlotDiv d-none">
                    <div class="col-xl-12">
                        <label class="primary_input_label"
                               for="edit_time_slot_id">{{ __('appointment.Time Slot') }}</label>
                        <select class="primary_select time_slot_id" name="slot"
                                {{ $errors->has('time_slot') ? 'autofocus' : '' }}
                                id="edit_time_slot_id_{{ $teachingInfo->id }}">
                            <option data-display="{{ __('common.Select') }} {{ __('appointment.Time Slot') }} "
                                    value="">
                                {{ __('common.Select') }} {{ __('appointment.Time Slot') }} </option>
                            @isset($teachingInfo)
                                @foreach ($teachingInfo->userInfo->timeSlots as $slot)
                                    <option value="{{ $slot->id }}"
                                        {{ $teachingInfo->slot_id == $slot->id ? 'selected' : '' }}>
                                        {{ date('h:i A', strtotime(@$slot->start_time)) . '-' . date('h:i A', strtotime(@$slot->end_time)) }}
                                    </option>
                                @endforeach
                            @endisset
                        </select>
                    </div>
                </div>
                <div class="col-lg-12 text-center pt_15 mt-25">
                    <div class="d-flex justify-content-center">
                        <button class="primary-btn semi_large2  fix-gr-bg updateScheduleButton"
                                id="updateScheduleButton_{{ $teachingInfo->id }}" type="submit"><i
                                class="ti-check"></i> {{ __('common.Update') }}
                        </button>

                        <button class="primary-btn semi_large2  fix-gr-bg d-none" type="button" disabled
                                id="updatingButton_{{ $teachingInfo->id }}">
                            {{ __('common.Updating') }} ....
                            <span class="spinner-border spinner-border-sm" role="status" aria-hidden="true"></span>
                            <span class="sr-only"></span>
                        </button>
                    </div>
                </div>
                </form>
            </div>
        </div>
    </div>
</div>
