<div class="row">
    <div class="col-md-4">
        <div class="primary_input mb-25">
            <label class="primary_input_label"
                   for="name">{{ __('common.Name') }} <strong
                    class="text-danger">*</strong></label>
            <input class="primary_input_field" name="name"
                   value="{{ @$user->name }}" id="name" placeholder=""
                   required type="text"
                {{ $errors->first('name') ? 'autofocus' : '' }}>
        </div>
    </div>
    <div class="col-xl-4">
        <div class="primary_input mb-25">
            <label class="primary_input_label" for="">{{ __('appointment.Specialist') }} <strong
                    class="text-danger"></strong></label>
            <input class="primary_input_field" name="headline" placeholder="-" id="headline" type="text"
                   value="{{ @$user->headline }}">
        </div>
    </div>

    <div class="col-md-4">
        <div class="primary_input mb-25">
            <label class="primary_input_label"
                   for="role">{{ __('common.Role') }} </label>
            <input class="primary_input_field" name="" readonly
                   id="role" value="{{ @$user->role->name }}"
                   placeholder="-" type="text">
        </div>
    </div>

    <div class="col-md-4">
        <div class="primary_input mb-25">
            <label class="primary_input_label"
                   for="email">{{ __('common.Email') }}
                <strong class="text-danger">*</strong></label>
            <input class="primary_input_field" name="email"
                   value="{{ @$user->email }}" id="email" placeholder="-"
                   type="email"
                {{ $errors->first('email') ? 'autofocus' : '' }}>
        </div>
    </div>

    <div class="col-md-4">
        <div class="primary_input mb-25">
            <label class="primary_input_label"
                   for="phone">{{ __('common.Phone') }} </label>
            <input class="primary_input_field" name="phone"
                   value="{{ @$user->phone }}" id="phone" placeholder="-"
                   type="text">
        </div>
    </div>

    <div class="col-md-4 mb-25">
        <label class="primary_input_label"
               for="country">{{ __('common.Country') }} </label>
        <select class="primary_select" name="country" id="country">
            @foreach ($countries as $country)
                <option value="{{ @$country->id }}"
                        @if (@$user->country == $country->id) selected @endif>
                    {{ @$country->name }}</option>
            @endforeach
        </select>
    </div>

    <div class="col-md-4 mb-25">
        <label class="primary_input_label"
               for="state">{{ __('common.State') }} </label>
        <select class="select2  stateList" name="state" id="state">
            <option
                data-display=" {{ __('common.Select') }} {{ __('common.State') }}"
                value="">{{ __('common.Select') }}
                {{ __('common.State') }}
            </option>
            @foreach ($states as $state)
                <option value="{{ @$state->id }}"
                        @if (@$user->state == $state->id) selected @endif>
                    {{ @$state->name }}</option>
            @endforeach
        </select>
    </div>
    <div class="col-md-4 mb-25">
        <label class="primary_input_label"
               for="city">{{ __('common.City') }} </label>
        <select class="select2  cityList" name="city" id="city">
            <option
                data-display=" {{ __('common.Select') }} {{ __('common.City') }}"
                value="">{{ __('common.Select') }}
                {{ __('common.City') }}
            </option>
            @foreach ($cities as $city)
                <option value="{{ @$city->id }}"
                        @if (@$user->city == $city->id) selected @endif>
                    {{ @$city->name }}</option>
            @endforeach
        </select>
    </div>


    <div class="col-md-4">
        <div class="primary_input mb-25">
            <label class="primary_input_label"
                   for="zip">{{ __('common.Zip Code') }} </label>
            <input class="primary_input_field" name="zip"
                   value="{{ @$user->zip }}" id="zip" placeholder="-"
                   type="text">
        </div>
    </div>

    <div class="col-md-4 mb-25">
        <label class="primary_input_label"
               for="currency">{{ __('common.Currency') }}</label>
        <select class="primary_select" name="currency" id="currency">
            <option data-display="{{ __('common.Select') }} Currency"
                    value="">{{ __('common.Select') }} Currency
            </option>
            @foreach ($currencies as $currency)
                <option value="{{ @$currency->id }}"
                        @if (@$user->currency_id == $currency->id) selected @endif>
                    {{ @$currency->name }}</option>
            @endforeach

        </select>
    </div>
    <div class="col-md-4 mb-25">
        <label class="primary_input_label"
               for="language">{{ __('common.Language') }} </label>
        <select class="primary_select" name="language" id="language">
            <option data-display="{{ __('common.Select') }} Language"
                    value="">{{ __('common.Select') }}
                {{ __('passwords.Language') }}</option>
            @foreach ($languages as $language)
                <option value="{{ @$language->id }}"
                        @if (@$user->language_id == $language->id) selected @endif>
                    {{ @$language->native }}
                </option>
            @endforeach
        </select>
    </div>


    <div class="col-12">
        @includeIf('appointment::instructor.inc.social', [
            'editInstructor' => $user,
        ])
    </div>
    <div class="col-8">
        <div class="primary_input mb-35">
            <label class="primary_input_label"
                   for="">{{ __('common.Browse') }}
                {{ __('common.Avatar') }} </label>
            <div class="primary_file_uploader">
                <input class="primary-input" type="text"
                       id="placeholderFileOneName"
                       placeholder="{{ showPicName($user->image) }}"
                       readonly="">
                <button class="primary-btn small fix-gr-bg" type="button">
                    <label class="primary-btn small fix-gr-bg"
                           for="document_file_1">{{ __('common.Browse') }}
                    </label>
                    <input type="file" class="d-none"
                           name="image" id="document_file_1">
                </button>
            </div>
        </div>
    </div>

    <div class="col-xl-4">
        <div class="primary_input mb-25">
            <label class="primary_input_label" for="">
                @php
                    $type = Settings('currency_show');
                @endphp
                {{ $type==1 || $type==2 ? '('.Settings('currency_symbol').')':'' }}
                {{ __('appointment.Hour Rate') }}  {{ $type==3 || $type==4 ? '('. Settings('currency_symbol'). ')':'' }}
            </label>
            <input class="primary_input_field" value="{{ $user->hour_rate }}" name="hour_rate"
                   id="addPhone" placeholder="{{Settings('currency_symbol')}}"
                   {{ $errors->first('hour_rate') ? 'autofocus' : '' }}
                   type="text">
        </div>
    </div>
    <div class="col-md-6">
        <div class="primary_input mb-25">
            <label class="primary_input_label"
                   for="shortDetails">{{ __('common.Short Description') }}
            </label>
            <input class="primary_input_field" name="short_details"
                   id="shortDetails" value="{{ @$user->short_details }}"
                   placeholder="-" type="text">
        </div>
    </div>
    <div class="col-xl-6">
        <div class="primary_input mb-25">
            <label class="primary_input_label" for="">{{ __('appointment.Short video Link') }} <strong
                    class="text-danger"></strong></label>
            <input class="primary_input_field" name="video_link" placeholder="www." id="video_link" type="text"
                   value="{{ $user->short_video_link }}">
        </div>
    </div>
    <div class="col-md-12">
        <div class="primary_input mb-25">
            <label class="primary_input_label"
                   for="about">{{ __('common.Description') }} </label>
            <textarea class="lms_summernote" name="about" id="about" cols="30"
                      rows="10">{!! @$user->about !!}</textarea>
        </div>
    </div>

    @auth()
        @if (\Illuminate\Support\Facades\Auth::user()->role_id == 1)
            <div class="col-12">
                <div class="col-md-4 mb-25">
                    <label class="primary_input_label"
                           for="subscription_method">{{ __('common.Subscription Method') }}
                    </label>
                    <select class="primary_select"
                            name="subscription_method">
                        <option value="">{{ __('common.None') }}</option>
                        <option value="Mailchimp"
                                @if ($user->subscription_method == 'Mailchimp') selected @endif>
                            {{ __('newsletter.Mailchimp') }}</option>

                        <option value="GetResponse"
                                @if ($user->subscription_method == 'GetResponse') selected @endif>
                            {{ __('newsletter.GetResponse') }}</option>

                    </select>
                </div>
                <div class="col-md-4 mb-25" style="    margin-top: 70px;">

                    <label class="primary_input_label"
                           for="subscription_api_key">{{ __('common.Subscription Api Key') }}
                        <small>({{ $user->subscription_api_status == 1 ? 'Connected' : 'Not Connected' }}
                            )</small> </label>
                    <input class="primary_input_field"
                           name="subscription_api_key"
                           value="{{ @$user->subscription_api_key }}"
                           id="subscription_api_key" placeholder="-"
                           type="text">

                </div>

                <div class="col-md-4">

                </div>
            </div>
        @endif
    @endauth

    <div class="col-12 mb-10">
        <div class="submit_btn text-center">
            <button class="primary-btn fix-gr-bg" type="submit"><i
                    class="ti-check"></i>
                {{ __('common.Save') }} </button>
        </div>
    </div>
</div>
