<?php

namespace Modules\Appointment\Http\Controllers;

use Carbon\Carbon;
use Illuminate\Http\Request;
use Illuminate\Routing\Controller;
use Brian2694\Toastr\Facades\Toastr;
use Illuminate\Contracts\Support\Renderable;
use Modules\Appointment\Http\Requests\TimeSlotRequest;
use Modules\Appointment\Repositories\Interfaces\TimeSlotRepositoryInterface;

class TimeSlotController extends Controller
{
    public $timeSlotRepository;

    public function __construct(
        TimeSlotRepositoryInterface $timeSlotRepository
    )
    {
        $this->timeSlotRepository = $timeSlotRepository;
    }

    public function index()
    {
        $data = $this->timeSlotRepository->index();
        return view('appointment::timeSlot.time_slot', $data);
    }


    public function create()
    {
        return view('appointment::create');
    }


    public function store(TimeSlotRequest $request)
    {
        $this->timeSlotRepository->create($request->except('_token'));
        Toastr::success(trans('common.Operation successful'), trans('common.Success'));
        return redirect()->back();
    }


    public function show($id)
    {
        return view('appointment::show');
    }

    public function edit($id)
    {
        $data = $this->timeSlotRepository->getEditValue($id);
        return view('appointment::timeSlot.time_slot', $data);
    }


    public function update(Request $request, $id)
    {
        $this->timeSlotRepository->update($id, $request->except('_token'));
        Toastr::success(trans('common.Operation successful'), trans('common.Success'));
        return redirect()->route('appointment.time-slot.index');
    }


    public function destroy($id)
    {
        $this->timeSlotRepository->deleteById($id);
        Toastr::success(trans('common.Operation successful'), trans('common.Success'));
        return redirect()->route('appointment.time-slot.index');
    }
}
