<div class="modal-dialog modal_800px modal-dialog-centered">
    <div class="modal-content">
        <div class="modal-header">
            <h4 class="modal-title"><?php echo e(__('setting.Edit Currency Info')); ?></h4>
            <button type="button" class="btn-close" data-bs-dismiss="modal">
                <i class="ti-close "></i>
            </button>
        </div>

        <div class="modal-body">
            <form action="<?php echo e(route('currencies.update', $currency->id)); ?>" method="POST" id="currencyEditForm">
                <?php echo csrf_field(); ?>
                <?php echo method_field('PATCH'); ?>
                <div class="row">

                    <div class="col-xl-12">
                        <div class="primary_input mb-25">
                            <label class="primary_input_label" for=""><?php echo e(__('common.Name')); ?> <strong
                                    class="text-danger">*</strong></label>
                            <input name="name" class="primary_input_field name" value="<?php echo e($currency->name); ?>"
                                   placeholder="Language Name" type="text" required>
                            <span class="text-danger"><?php echo e($errors->first("name")); ?></span>
                        </div>
                    </div>

                    <div class="col-xl-12">
                        <div class="primary_input mb-25">
                            <label class="primary_input_label" for=""><?php echo e(__('setting.Code')); ?> <strong
                                    class="text-danger">*</strong></label>
                            <input name="code" class="primary_input_field name" value="<?php echo e($currency->code); ?>"
                                   placeholder="Language Code" type="text" required>
                            <span class="text-danger"><?php echo e($errors->first("code")); ?></span>
                        </div>
                    </div>

                    <div class="col-xl-12">
                        <div class="primary_input mb-25">
                            <label class="primary_input_label" for=""><?php echo e(__('setting.Symbol')); ?> <strong
                                    class="text-danger">*</strong></label>
                            <input name="symbol" class="primary_input_field name" value="<?php echo e($currency->symbol); ?>"
                                   placeholder="$" type="text" required>
                            <span class="text-danger"><?php echo e($errors->first("symbol")); ?></span>
                        </div>
                    </div>
                    

                    <div class="col-xl-12">
                        <div class="primary_input mb-25">
                            <label class="primary_input_label" for=""><?php echo e(__('setting.Conversion Rate')); ?>

                                1 <?php echo e(Settings('currency_code')); ?> = ? <strong class="text-danger">*</strong></label>
                            <input name="conversion_rate" class="primary_input_field name"
                                   value="<?php echo e($currency->conversion_rate); ?>" placeholder="1" type="text" required>
                        </div>
                    </div>

                    <div class="col-lg-12 text-center">
                        <div class="d-flex justify-content-center pt_20">
                            <button type="submit" class="primary-btn semi_large2 fix-gr-bg" id="save_button_parent">
                                <i class="ti-check"></i><?php echo e(__('common.Update')); ?>

                            </button>
                        </div>
                    </div>
                </div>
            </form>
        </div>

    </div>
</div>

<?php /**PATH /home/minialms/app.minialms.com/Modules/Setting/Resources/views/currencies/edit_modal.blade.php ENDPATH**/ ?>