<?php

namespace Modules\UpcomingCourse\Jobs;

use App\Traits\SendNotification;
use App\User;
use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Foundation\Bus\Dispatchable;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Queue\SerializesModels;
use Modules\CourseSetting\Entities\Course;
use Modules\UpcomingCourse\Entities\UpcomingCourseBooking;
use Modules\UpcomingCourse\Entities\UpcomingCourseFollower;

class PublishCourseJob implements ShouldQueue
{
    use Dispatchable, InteractsWithQueue, Queueable, SerializesModels, SendNotification;

    protected $id;

    public function __construct($id)
    {
        $this->id = $id;
    }

    public function handle()
    {
        $course = Course::find($this->id);
        $followers = UpcomingCourseFollower::where('course_id', $this->id)->pluck('user_id')->toArray();
        $bookings = UpcomingCourseBooking::where('course_id', $this->id)->pluck('user_id')->toArray();
        $user_ids = array_merge($followers, $bookings);
        $users = User::whereIn('id', $user_ids)->get(['name', 'email', 'role_id']);
        if ($users->count() > 0) {
            foreach ($users as $user) {
                $this->sendNotification('PUBLISH_COURSE', $user, [
                    'course' => $course->title,
                    'publish_date' => date('Y-m-d'),
                    'link' => courseDetailsUrl($course->id, @$course->type, @$course->slug),
                    'name' => $user->name,
                ]);
            }
        }
    }
}
