<?php

use Illuminate\Support\Facades\DB;
use Illuminate\Database\Migrations\Migration;
use Modules\SystemSetting\Entities\EmailTemplate;

class AddEmailTemplateForPublishCourse extends Migration
{
    public function up()
    {
        $template = EmailTemplate::where('act', 'PUBLISH_COURSE')->first();
        if (!$template) {
            $template = new EmailTemplate();
            $template->act = 'PUBLISH_COURSE';
        }
        $shortCode = '{"name":"Student/Instructor/User Name","course":"Course","publish_date":"Publish Date","link":"Course Link"}';


        $subject = 'Course Published: {{course}}';


        $br = "<br/>";

        $body = "Hello,: {{name}} "
            . $br . "We are excited to inform you that the course {{course}} has been published."
            . $br . "The course is now available for enrollment."
            . $br . "Click Here to see detail: {{link}},"
            . "{{footer}}";
        $template->name = $subject;
        $template->subj = $subject;
        $template->shortcodes = $shortCode;
        $template->status = 1;

        $template->email_body = htmlPart($subject, $body);
        $template->save();

        DB::table('role_email_templates')
            ->where('template_act', 'BLOG_PUBLISH')
            ->where('role_id', 4,)
            ->updateOrInsert([
                'template_act' => 'POSTED_NOTIFICATION',
                'role_id' => 4,
                'status' => 1,
            ]);

        DB::table('role_email_templates')
            ->where('template_act', 'BLOG_PUBLISH')
            ->where('role_id', 3,)
            ->updateOrInsert([
                'template_act' => 'POSTED_NOTIFICATION',
                'role_id' => 3,
                'status' => 1,
            ]);

        DB::table('role_email_templates')
            ->where('template_act', 'BLOG_PUBLISH')
            ->where('role_id', 2,)
            ->updateOrInsert([
                'template_act' => 'POSTED_NOTIFICATION',
                'role_id' => 2,
                'status' => 1,
            ]);
        DB::table('role_email_templates')
            ->where('template_act', 'BLOG_PUBLISH')
            ->where('role_id', 1,)
            ->updateOrInsert([
                'template_act' => 'POSTED_NOTIFICATION',
                'role_id' => 1,
                'status' => 1,
            ]);
    }
}
