<?php

namespace Modules\Survey\Entities;

use App\Traits\Tenantable;
use App\User;
use App\StudentGroup;
use Illuminate\Database\Eloquent\Model;

class SurveyAssign extends Model
{
    use Tenantable;

    protected $fillable = [];

    public function survey()
    {
        return $this->belongsTo(Survey::class, 'survey_id', 'id')
            ->where('publish_date', '<=', date(getActivePhpDateFormat()))
            ->where('publish_time', '<=', date("h:i:sa"))
            ->withDefault();
    }

    public function user()
    {
        return $this->belongsTo(User::class, 'user_id', 'id')->withDefault();
    }

    public function questions()
    {
        return $this->hasMany(SurveyQuestionBank::class, 'survey_id', 'id');
    }
}
