<?php

use Illuminate\Support\Facades\Cache;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;
use Modules\RolePermission\Entities\Permission;

class AddSupportTicketRolePermission extends Migration
{

    public function up()
    {

        $routes = [
            [
                'name' => 'Support Ticket',
                'route' => 'ticket',
                'parent_route' => null,
                'type' => 1,
                'backend' => 1, 'module' => 'SupportTicket'
            ], [
                'name' => 'Ticket List',
                'route' => 'ticket.tickets.index',
                'parent_route' => 'ticket',
                'type' => 2,
                'backend' => 1, 'module' => 'SupportTicket'
            ], [
                'name' => 'Add',
                'route' => 'ticket.tickets.create',
                'parent_route' => 'ticket.tickets.index',
                'type' => 3,
                'backend' => 1, 'module' => 'SupportTicket'
            ],
            [
                'name' => 'Show',
                'route' => 'ticket.tickets.show',
                'parent_route' => 'ticket.tickets.index',
                'type' => 3,
                'backend' => 1, 'module' => 'SupportTicket'
            ],
            [
                'name' => 'Edit',
                'route' => 'ticket.tickets.edit',
                'parent_route' => 'ticket.tickets.index',
                'type' => 3,
                'backend' => 1, 'module' => 'SupportTicket'
            ], [
                'name' => 'Delete',
                'route' => 'ticket.tickets.destroy',
                'parent_route' => 'ticket.tickets.index',
                'type' => 3,
                'backend' => 1, 'module' => 'SupportTicket'
            ], [
                'name' => 'Assign Agent',
                'route' => 'ticket.assign.user',
                'parent_route' => 'ticket.tickets.index',
                'type' => 3,
                'backend' => 1, 'module' => 'SupportTicket'
            ], [
                'name' => 'Category',
                'route' => 'ticket.category.index',
                'parent_route' => 'ticket',
                'type' => 2,
                'backend' => 1, 'module' => 'SupportTicket'
            ], [
                'name' => 'Add',
                'route' => 'ticket.category.store',
                'parent_route' => 'ticket.category.index',
                'type' => 3,
                'backend' => 1, 'module' => 'SupportTicket'
            ], [
                'name' => 'Edit',
                'route' => 'ticket.category.edit',
                'parent_route' => 'ticket.category.index',
                'type' => 3,
                'backend' => 1, 'module' => 'SupportTicket'
            ], [
                'name' => 'Delete',
                'route' => 'ticket.category.delete',
                'parent_route' => 'ticket.category.index',
                'type' => 3,
                'backend' => 1, 'module' => 'SupportTicket'
            ], [
                'name' => 'Status',
                'route' => 'ticket.category.status',
                'parent_route' => 'ticket.category.index',
                'type' => 3,
                'backend' => 1, 'module' => 'SupportTicket'
            ],

            [
                'name' => 'Priority',
                'route' => 'ticket.priority.index',
                'parent_route' => 'ticket',
                'type' => 2,
                'backend' => 1, 'module' => 'SupportTicket'
            ], [
                'name' => 'Add',
                'route' => 'ticket.priority.create',
                'parent_route' => 'ticket.priority.index',
                'type' => 3,
                'backend' => 1, 'module' => 'SupportTicket'
            ], [
                'name' => 'Edit',
                'route' => 'ticket.priority.edit',
                'parent_route' => 'ticket.priority.index',
                'type' => 3,
                'backend' => 1, 'module' => 'SupportTicket'
            ], [
                'name' => 'Delete',
                'route' => 'ticket.priority.delete',
                'parent_route' => 'ticket.priority.index',
                'type' => 3,
                'backend' => 1, 'module' => 'SupportTicket'
            ], [
                'name' => 'Status',
                'route' => 'ticket.priority.status',
                'parent_route' => 'ticket.priority.index',
                'type' => 3,
                'backend' => 1, 'module' => 'SupportTicket'
            ],


            [
                'name' => 'Status',
                'route' => 'ticket.status.index',
                'parent_route' => 'ticket',
                'type' => 2,
                'backend' => 1, 'module' => 'SupportTicket'
            ], [
                'name' => 'Add',
                'route' => 'ticket.status.store',
                'parent_route' => 'ticket.status.index',
                'type' => 3,
                'backend' => 1, 'module' => 'SupportTicket'
            ], [
                'name' => 'Edit',
                'route' => 'ticket.status.edit',
                'parent_route' => 'ticket.status.index',
                'type' => 3,
                'backend' => 1, 'module' => 'SupportTicket'
            ], [
                'name' => 'Delete',
                'route' => 'ticket.status.delete',
                'parent_route' => 'ticket.status.index',
                'type' => 3,
                'backend' => 1, 'module' => 'SupportTicket'
            ], [
                'name' => 'Status',
                'route' => 'ticket.status.status',
                'parent_route' => 'ticket.status.index',
                'type' => 3,
                'backend' => 1, 'module' => 'SupportTicket'
            ],

            [
                'name' => 'Support Ticket',
                'route' => 'student.support-ticket.index',
                'parent_route' => null,
                'type' => 1,
                'backend' => 0, 'module' => 'SupportTicket'
            ],
            [
                'name' => 'My Ticket',
                'route' => 'ticket.my_ticket',
                'parent_route' => 'ticket',
                'type' => 2,
                'backend' => 1,
                'module' => 'SupportTicket'
            ],

        ];

        permissionUpdateOrCreate($routes);


        $permission = DB::table('permissions')->where('route', 'student.support-ticket.index')->first();
        if ($permission) {
            DB::table('role_permission')->insert([
                'permission_id' => $permission->id,
                'role_id' => 3,
            ]);
        }


        $routes = [
            'ticket',
            'ticket.tickets.index',
            'ticket.tickets.create',
            'ticket.tickets.edit',
            'ticket.tickets.destroy',
            'ticket.tickets.show',
        ];
        foreach ($routes as $route) {
            $permission = DB::table('permissions')->where('route', $route)->first();
            if ($permission) {
                DB::table('role_permission')->insert([
                    'permission_id' => $permission->id,
                    'role_id' => 2,
                ]);
            }
        }


    }

    public function down()
    {
        //
    }
}
