<?php


use Illuminate\Support\Facades\Route;

Route::prefix('store')->middleware(['auth'])->group(function () {

    Route::get('category', 'CategoryController@index')->name('store.category.index')->middleware('RoutePermissionCheck:store.category.index');
    Route::get('category/edit/{id}', 'CategoryController@edit')->name('store.category.edit')->middleware('RoutePermissionCheck:store.category.edit');
    Route::get('category/destroy/{id}', 'CategoryController@destroy')->name('store.category.destroy')->middleware('RoutePermissionCheck:store.category.destroy');
    Route::post('category/create', 'CategoryController@store')->name('store.category.store')->middleware('RoutePermissionCheck:store.category.store');
    Route::post('category/update', 'CategoryController@update')->name('store.category.update')->middleware('RoutePermissionCheck:store.category.update');
    Route::post('category/status-update', 'CategoryController@status')->name('store.category.status')->middleware('RoutePermissionCheck:store.category.status');


    // product Attribute

    Route::get('attribute', 'AttributeController@index')->name('store.attribute.index')->middleware('RoutePermissionCheck:store.attribute.index');
    Route::get('attribute/view/{id}', 'AttributeController@view')->name('store.attribute.view')->middleware('RoutePermissionCheck:store.attribute.view');
    Route::get('attribute/edit/{id}', 'AttributeController@edit')->name('store.attribute.edit')->middleware('RoutePermissionCheck:store.attribute.edit');
    Route::get('attribute/destroy/{id}', 'AttributeController@destroy')->name('store.attribute.destroy')->middleware('RoutePermissionCheck:store.attribute.destroy');
    Route::post('attribute/create', 'AttributeController@store')->name('store.attribute.store')->middleware('RoutePermissionCheck:store.attribute.store');
    Route::post('attribute/update', 'AttributeController@update')->name('store.attribute.update')->middleware('RoutePermissionCheck:store.attribute.update');
    Route::post('attribute/status-update', 'AttributeController@status')->name('store.attribute.status')->middleware('RoutePermissionCheck:store.attribute.status');

    Route::post('/attribute/value/delete', 'AttributeController@delete')->name('attributeValue.delete')->middleware('RoutePermissionCheck:attributeValue.delete');


    Route::get('brand', 'BrandController@index')->name('store.brand.index')->middleware('RoutePermissionCheck:store.brand.index');
    Route::get('brand/edit/{id}', 'BrandController@edit')->name('store.brand.edit')->middleware('RoutePermissionCheck:store.brand.edit');
    Route::get('brand/destroy/{id}', 'BrandController@destroy')->name('store.brand.destroy')->middleware('RoutePermissionCheck:store.brand.destroy');
    Route::get('brand/create', 'BrandController@create')->name('store.brand.create')->middleware('RoutePermissionCheck:store.brand.create');
    Route::post('brand/store', 'BrandController@store')->name('store.brand.store')->middleware('RoutePermissionCheck:store.brand.store');
    Route::post('brand/update/{id}', 'BrandController@update')->name('store.brand.update')->middleware('RoutePermissionCheck:store.brand.update');
    Route::post('brand/status-update', 'BrandController@status')->name('store.brand.status')->middleware('RoutePermissionCheck:store.brand.status');
    Route::post('brand/feature-update', 'BrandController@feature')->name('store.brand.feature')->middleware('RoutePermissionCheck:store.brand.feature');


    // product Author

    Route::get('author', 'AuthorController@index')->name('store.author.index')->middleware('RoutePermissionCheck:store.author.index');
    Route::get('author/edit/{id}', 'AuthorController@edit')->name('store.author.edit')->middleware('RoutePermissionCheck:store.author.edit');
    Route::get('author/destroy/{id}', 'AuthorController@destroy')->name('store.author.destroy')->middleware('RoutePermissionCheck:store.author.destroy');
    Route::post('author/create', 'AuthorController@store')->name('store.author.store')->middleware('RoutePermissionCheck:store.author.store');
    Route::post('author/update', 'AuthorController@update')->name('store.author.update')->middleware('RoutePermissionCheck:store.author.update');
    Route::post('author/status-update', 'AuthorController@status')->name('store.author.status')->middleware('RoutePermissionCheck:store.author.status');

    //Unit Routes
    Route::get('unit', 'UnitController@index')->name('store.unit.index')->middleware('RoutePermissionCheck:store.unit.index');
    Route::get('unit/edit/{id}', 'UnitController@edit')->name('store.unit.edit')->middleware('RoutePermissionCheck:store.unit.edit');
    Route::get('unit/destroy/{id}', 'UnitController@destroy')->name('store.unit.destroy')->middleware('RoutePermissionCheck:store.unit.destroy');
    Route::post('unit/create', 'UnitController@store')->name('store.unit.store')->middleware('RoutePermissionCheck:store.unit.store');
    Route::post('unit/update', 'UnitController@update')->name('store.unit.update')->middleware('RoutePermissionCheck:store.unit.update');
    Route::post('unit/status-update', 'UnitController@status')->name('store.unit.status')->middleware('RoutePermissionCheck:store.unit.status');

    //Publication Route
    Route::get('publication', 'PublicationController@index')->name('store.publication.index')->middleware('RoutePermissionCheck:store.publication.index');
    Route::get('publication/edit/{id}', 'PublicationController@edit')->name('store.publication.edit')->middleware('RoutePermissionCheck:store.publication.edit');
    Route::get('publication/destroy/{id}', 'PublicationController@destroy')->name('store.publication.destroy')->middleware('RoutePermissionCheck:store.publication.destroy');
    Route::post('publication/create', 'PublicationController@store')->name('store.publication.store')->middleware('RoutePermissionCheck:store.publication.store');
    Route::post('publication/update', 'PublicationController@update')->name('store.publication.update')->middleware('RoutePermissionCheck:store.publication.update');
    Route::post('publication/status-update', 'PublicationController@status')->name('store.publication.status')->middleware('RoutePermissionCheck:store.publication.status');


    // product

    Route::get('getAllproduct', 'ProductController@getAllproducts')->name('getAllproduct');
    Route::get('/productlist', 'ProductController@index')->name('store.product.index')->middleware('RoutePermissionCheck:store.product.index');


    Route::get('product/show/{id}', 'ProductController@show')->name('store.product.show')->middleware('auth');
    Route::get('product/edit/{id}', 'ProductController@edit')->name('store.product.edit')->middleware('RoutePermissionCheck:store.product.edit');
    Route::get('product/destroy/{id}', 'ProductController@destroy')->name('store.product.destroy')->middleware('RoutePermissionCheck:store.product.destroy');
    Route::get('product/create', 'ProductController@create')->name('store.product.create')->middleware('RoutePermissionCheck:store.product.create');
    Route::post('product/store', 'ProductController@store')->name('store.product.store')->middleware('RoutePermissionCheck:store.product.store');
    Route::post('product/update', 'ProductController@update')->name('store.product.update')->middleware('RoutePermissionCheck:store.product.update');
    Route::post('product/status-update', 'ProductController@status')->name('store.product.status')->middleware('RoutePermissionCheck:store.product.status');
    Route::get('product/sku_combination', 'ProductController@sku_combination')->name('store.product.sku_combination')->middleware('auth');
    Route::get('bulk-product-upload', 'ProductImportController@bulk_product_upload_page')->name('bulk_product_upload_page')->middleware('RoutePermissionCheck:bulk_product_upload_page');
    Route::post('bulkProduct/store', 'ProductImportController@bulk_product_store')->name('product.bulk_product_store');
    Route::get('products-excel-download', 'ProductImportController@export')->name('product.excel.download')->middleware('RoutePermissionCheck:product.excel.download');
    Route::get('export-all-product', 'ProductController@exportAllProduct')->name('exportAllProduct')->middleware('RoutePermissionCheck:product.excel.download');

    Route::get('export-sample-product', 'ProductController@exportSampleProduct')->name('exportSampleProduct')->middleware('RoutePermissionCheck:exportSampleProduct');

    //Get Course Subcategory
    Route::get('/product/ajaxGetProductSubCategory', 'ProductController@ajaxGetProductSubCategory');

    Route::get('/product/getAttributeValues', 'AttributeController@attribute_values')->name('store.attribute.values');

    //fronted

    Route::get('product/details/{id}', 'ProductController@productDetails')->name('store.product.details')->middleware('RoutePermissionCheck:store.product.details');
    Route::get('allproducts', 'ProductController@getAllproduct')->name('store.product.all')->middleware('RoutePermissionCheck:store.product.all');


    //product riview

    Route::get('product/review', 'ProductController@getReviews')->name('store.product.getReviews')->middleware('RoutePermissionCheck:store.product.getReviews');
    Route::post('product/review/status-update', 'ProductController@reviewstatus')->name('store.product.reviewstatus')->middleware('RoutePermissionCheck:store.product.reviewstatus');

    //fronted
    Route::post('product/givereview', 'ProductController@giveReview')->name('store.product.giveReview')->middleware('RoutePermissionCheck:store.product.giveReview');

    //Carrier Routes
    Route::get('carrier', 'CarrierController@index')->name('store.carrier.index')->middleware('RoutePermissionCheck:store.carrier.index');
    Route::get('carrier/edit/{id}', 'CarrierController@edit')->name('store.carrier.edit')->middleware('RoutePermissionCheck:store.carrier.index');
    Route::get('carrier/destroy/{id}', 'CarrierController@destroy')->name('store.carrier.destroy')->middleware('RoutePermissionCheck:store.carrier.index');
    Route::post('carrier/create', 'CarrierController@store')->name('store.carrier.store')->middleware('RoutePermissionCheck:store.carrier.index');
    Route::post('carrier/update', 'CarrierController@update')->name('store.carrier.update')->middleware('RoutePermissionCheck:store.carrier.index');
    Route::post('carrier/status-update', 'CarrierController@status')->name('store.carrier.status')->middleware('RoutePermissionCheck:store.carrier.index');


    //Rate Routes
    Route::get('rate', 'RateController@index')->name('store.shiprate.index')->middleware('RoutePermissionCheck:store.shiprate.index');
    Route::get('rate/edit/{id}', 'RateController@edit')->name('store.shiprate.edit')->middleware('RoutePermissionCheck:store.shiprate.index');
    Route::get('rate/destroy/{id}', 'RateController@destroy')->name('store.shiprate.destroy')->middleware('RoutePermissionCheck:store.shiprate.index');
    Route::post('rate/create', 'RateController@store')->name('store.shiprate.store')->middleware('RoutePermissionCheck:store.shiprate.index');
    Route::post('rate/update', 'RateController@update')->name('store.shiprate.update')->middleware('RoutePermissionCheck:store.shiprate.index');
    Route::post('rate/status-update', 'RateController@status')->name('store.shiprate.status')->middleware('RoutePermissionCheck:store.shiprate.index');

    //Pickup Location Routes
    Route::get('pickup-location', 'PickupLocationController@index')->name('store.pickuplocation.index')->middleware('RoutePermissionCheck:store.pickuplocation.index');
    Route::get('pickup-location/edit/{id}', 'PickupLocationController@edit')->name('store.pickuplocation.edit')->middleware('RoutePermissionCheck:store.pickuplocation.index');
    Route::get('pickup-location/show/{id}', 'PickupLocationController@show')->name('store.pickuplocation.show')->middleware('RoutePermissionCheck:store.pickuplocation.index');
    Route::get('pickup-location/destroy/{id}', 'PickupLocationController@destroy')->name('store.pickuplocation.destroy')->middleware('RoutePermissionCheck:store.pickuplocation.index');
    Route::post('pickup-location/create', 'PickupLocationController@store')->name('store.pickuplocation.store')->middleware('RoutePermissionCheck:store.pickuplocation.index');
    Route::any('pickup-location/update/{id?}', 'PickupLocationController@update')->name('store.pickuplocation.update')->middleware('RoutePermissionCheck:store.pickuplocation.index');
    Route::post('pickup-location/status-update', 'PickupLocationController@status')->name('store.pickuplocation.status')->middleware('RoutePermissionCheck:store.pickuplocation.index');
    Route::post('pickup-location/set-default', 'PickupLocationController@setDefault')->name('store.pickuplocation.set_default')->middleware('RoutePermissionCheck:store.pickuplocation.index');
    Route::get('/pickup-location/get-state', 'PickupLocationController@get_states')->name('store.pickuplocation.get_state')->middleware('RoutePermissionCheck:store.pickuplocation.index');
    Route::get('/pickup-location/get-city', 'PickupLocationController@get_cities')->name('store.pickuplocation.get_city')->middleware('RoutePermissionCheck:store.pickuplocation.index');
    Route::get('set/pickup_location/{id}', 'PickupLocationController@setPickupLocation')->name('store.pickup_locations.set');

    //Packaging Routes
    Route::get('/packaging/edit/{id}', 'ShippingOrderController@editPackaging')->name('store.packaging.edit');
    Route::post('/packaging/update', 'ShippingOrderController@updatePackaging')->name('store.packaging.update');

    //shipping-carrier-change

    Route::post('/carrier-change', 'ShippingOrderController@carrierChange')->name('store.carrier_change');

    //Shipping Order Routes
    Route::get('/shipping-orders', 'ShippingOrderController@index')->name('store.shiporder.index');
    Route::get('/method-change/{id}', 'ShippingOrderController@singleOrderMethodChange')->name('store.single_order_method_change');
    Route::post('/method-update', 'ShippingOrderController@methodUpdate')->name('store.method_update');

    Route::get('/update-carrier-order/{id}', 'ShippingOrderController@updateCarrierOrder')->name('store.update_carrier_order');
    Route::get('/edit-carrier-order/{id}', 'ShippingOrderController@editCarrierOrder')->name('store.edit_carrier_order');
    Route::post('/carrier-order-update', 'ShippingOrderController@carrierOrderUpdate')->name('store.carrier_order_update');
    Route::get('/customer-address-edit/{id}', 'ShippingOrderController@customerAddressEdit')->name('store.customer_address_edit');
    Route::post('/customer-address-update', 'ShippingOrderController@customerAddressUpdate')->name('store.customer_address_update');
    Route::get('/carrier-status/{id}', 'ShippingOrderController@carrierStatus')->name('store.carrier_status');
    Route::get('/label-generate/{id}', 'ShippingOrderController@labelGenerate')->name('shipping.label_generate');
    Route::get('/method-change/{id}', 'ShippingOrderController@singleOrderMethodChange')->name('shipping.single_order_method_change');
    Route::get('/invoice-generate/{id}', 'ShippingOrderController@invoiceGenerate')->name('shipping.invoice_generate');


//Order Manage
    Route::get('product/order', 'ProductOrderController@index')->name('store.orders.index')->middleware('RoutePermissionCheck:store.orders.index');
    Route::get('product/order/invoice/{id}', 'ProductOrderController@showInvoice')->name('store.order.invoice')->middleware('RoutePermissionCheck:store.order.invoice');
    Route::get('product/track/order/settings', 'ProductOrderController@track_order_configuration')->name('store.trackorder.settings')->middleware('RoutePermissionCheck:store.trackorder.settings');
    Route::post('track-order-configuration-update', 'ProductOrderController@track_order_configuration_update')->name('store.track_order_configuration.update')->middleware('RoutePermissionCheck:store.trackorder.settings');

    Route::get('getAllOrder', 'ProductOrderController@getAllOrders')->name('getAllOrder');
    Route::get('/sales-details/{id}', 'ProductOrderController@show')->name('order_manage.show_details')->middleware('RoutePermissionCheck:store.orders.index');
    Route::get('/sales-details-print/{id}', 'ProductOrderController@globalPrint')->name('order_manage.print_order_details')->middleware('RoutePermissionCheck:store.orders.index');
    Route::get('/my-sales-details-print/{id}', 'ProductOrderController@myGlobalPrint')->name('order_manage.print_my_order_details')->middleware('RoutePermissionCheck:store.my_order.index');
    Route::post('/sales-info-update-admin/{id}', 'ProductOrderController@sales_info_update')->name('order_manage.order_update_info')->middleware('RoutePermissionCheck:store.orders.index');
    Route::get('/order/confirm/{id}', 'ProductOrderController@orderConfirm')->name('admin.order.confirm')->middleware('RoutePermissionCheck:store.orders.index');
    Route::get('/my-sales-list', 'ProductOrderController@my_sales_index')->name('store.my_order.index')->middleware('RoutePermissionCheck:store.my_order.index');
    Route::get('/my-sales-list/get-data', 'ProductOrderController@my_sales_get_data')->name('store.my_sales_get_data')->middleware('RoutePermissionCheck:store.my_order.index');
    Route::get('/my-sales-details/{id}', 'ProductOrderController@my_sale_show')->name('store.order_manage.show_details_mine')->middleware('RoutePermissionCheck:store.my_order.index');
    Route::post('/sales-info-update-delivery/{id}', 'ProductOrderController@update_delivery')->name('order_manage.update_delivery_status')->middleware('RoutePermissionCheck:store.my_order.index');
    Route::post('/my-purchase-package-order-cancel', 'ProductOrderController@my_purchase_order_package_cancel')->name('frontend.my_purchase_order_package_cancel');

//deliverprocess

    Route::get('deilvery', 'DeliveryProcessController@index')->name('store.delivery.index')->middleware('RoutePermissionCheck:store.delivery.index');
    Route::get('deilvery/edit/{id}', 'DeliveryProcessController@edit')->name('store.delivery.edit')->middleware('RoutePermissionCheck:store.delivery.index');
    Route::get('deilvery/destroy/{id}', 'DeliveryProcessController@destroy')->name('store.delivery.destroy')->middleware('RoutePermissionCheck:store.delivery.index');
    Route::post('deilvery/create', 'DeliveryProcessController@store')->name('store.delivery.store')->middleware('RoutePermissionCheck:store.delivery.index');
    Route::post('deilvery/update', 'DeliveryProcessController@update')->name('store.delivery.update')->middleware('RoutePermissionCheck:store.delivery.index');
    Route::post('deilvery/status-update', 'DeliveryProcessController@status')->name('store.delivery.status')->middleware('RoutePermissionCheck:store.delivery.index');
    Route::get('/delivery-process-list', 'DeliveryProcessController@process_list')->name('store.delivery.process_list');


//cancel Reason

    Route::get('cancelreason', 'CancelReasonController@index')->name('store.cancelreason.index')->middleware('RoutePermissionCheck:store.cancelreason.index');
    Route::get('cancelreason/edit/{id}', 'CancelReasonController@edit')->name('store.cancelreason.edit')->middleware('RoutePermissionCheck:store.cancelreason.edit');
    Route::get('cancelreason/destroy/{id}', 'CancelReasonController@destroy')->name('store.cancelreason.destroy')->middleware('RoutePermissionCheck:store.cancelreason.destroy');
    Route::post('cancelreason/create', 'CancelReasonController@store')->name('store.cancelreason.store')->middleware('RoutePermissionCheck:store.cancelreason.store');
    Route::post('cancelreason/update/{id}', 'CancelReasonController@update')->name('store.cancelreason.update')->middleware('RoutePermissionCheck:store.cancelreason.update');
    Route::post('cancelreason/status-update', 'CancelReasonController@status')->name('store.cancelreason.status')->middleware('RoutePermissionCheck:store.cancelreason.status');
    Route::get('/cancel-reason-list', 'CancelReasonController@process_list')->name('store.cancelreason.cancel_reason_list');


//my purchase history


    Route::get('refund-setting', 'RefundController@index')->name('store.refundsetting.index')->middleware('RoutePermissionCheck:store.refundsetting.index');
    Route::post('refundsetting-update', 'RefundController@refundsettingUpdate')->name('store.refundsetting.update')->middleware('RoutePermissionCheck:store.refundsetting.index');
    Route::get('refund-process', 'RefundProcessController@index')->name('store.refundprocess.index')->middleware('RoutePermissionCheck:store.refundprocess.index');
    Route::get('refund-process-destroy/{id}', 'RefundProcessController@destroy')->name('store.refundprocess.destroy')->middleware('RoutePermissionCheck:store.refundprocess.index');
    Route::post('refund-process-store', 'RefundProcessController@store')->name('store.refundprocess.store')->middleware('RoutePermissionCheck:store.refundprocess.index');
    Route::get('refund-process-list', 'RefundProcessController@process_list')->name('store.refundprocess.list')->middleware('RoutePermissionCheck:store.refundprocess.index');
    Route::get('/reasons-process-get/{id}', 'RefundProcessController@edit')->name('store.refundprocess.edit')->middleware('RoutePermissionCheck:store.refundprocess.edit');

    Route::post('refund-process-update/{id}', 'RefundProcessController@update')->name('store.refundprocess.update')->middleware('RoutePermissionCheck:store.refundprocess.index');
    Route::get('/all-pending-refund-request', 'RefundController@all_refund_request_index')->name('store.refundpending.index')->middleware('RoutePermissionCheck:store.refundpending.index');
    Route::get('/all-pending-refund-request-data', 'RefundController@all_refund_request_data')->name('refund.all_refund_request_data')->middleware('RoutePermissionCheck:store.refundpending.index');
    Route::get('/refund-request-details/{id}', 'RefundController@show')->name('refund.refund_show_details')->middleware('RoutePermissionCheck:store.refundpending.index');
    Route::post('/update-refund-request-info/{id}', 'RefundController@update_refund_request_by_admin')->name('refund.update_refund_request_by_admin')->middleware('RoutePermissionCheck:store.refundpending.index');
    Route::get('/all-confirmed-refund-request', 'RefundController@all_refund_request_confirmed_index')->name('store.refundconfirmed.index')->middleware('RoutePermissionCheck:store.refundconfirmed.index');
    Route::get('/my-refund-request', 'RefundController@seller_refund_request_list')->name('store.my_refund_requests.index')->middleware('RoutePermissionCheck:store.my_refund_requests.index');
    Route::get('/seller-pending-refund-request-data', 'RefundController@seller_refund_request_data')->name('refund.seller_refund_request_data')->middleware('RoutePermissionCheck:store.my_refund_requests.index');
    Route::get('/my-refund-request-details/{id}', 'RefundController@seller_show')->name('refund.my_refund_show_details')->middleware('RoutePermissionCheck:store.my_refund_requests.index');
    Route::post('/update-refund-state-info/{id}', 'RefundController@update_refund_state_by_seller')->name('refund.update_refund_detail_state_by_seller')->middleware('RoutePermissionCheck:store.my_refund_requests.index');


    Route::get('/reasons', 'RefundReasonController@reasons_list')->name('store.refundreason.index')->middleware('RoutePermissionCheck:store.refundreason.index');

    Route::get('/reasons-list', 'RefundReasonController@index')->name('store.reason.list')->middleware('RoutePermissionCheck:store.refundreason.index');
    Route::get('/reasons-get/{id}', 'RefundReasonController@edit')->name('store.reason.edit')->middleware('RoutePermissionCheck:store.refundreason.index');
    Route::post('/reasons-store', 'RefundReasonController@store')->name('store.reason.store')->middleware('RoutePermissionCheck:store.refundreason.index');
    Route::post('/refund-reason-update/{id}', 'RefundReasonController@update')->name('store.reason.update')->middleware('RoutePermissionCheck:store.refundreason.index');
    Route::get('/reason-destroy/{id}', 'RefundReasonController@destroy')->name('store.reason.destroy')->middleware('RoutePermissionCheck:store.refundreason.index');

    Route::get('shipping-setting', 'ShippingController@setting')->name('store.shipsetting.index')->middleware('RoutePermissionCheck:store.shipsetting.index');
    Route::post('shippingsetting-update', 'ShippingController@settingUpdate')->name('store.shippingsetting.update')->middleware('RoutePermissionCheck:store.shipsetting.index');
    Route::get('label/terms-conditions/delete/{id}', 'ShippingController@conditionDelete')->name('store.label.terms_condition.destroy');

});


//Frontend Routes
Route::group(['prefix' => 'store'], function () {
    Route::get('/', 'FrontendStoreController@products')->name('store.products');
});

Route::get('product-details/{slug}', 'FrontendStoreController@productDetails')->name('productDetailsView');
Route::get('product-sku-wise-price', 'FrontendStoreController@get_product_sku_wise_price')->name('get_product_sku_wise_price');
Route::get('update-product-qty-in-cart', 'FrontendStoreController@update_product_qty_in_cart')->name('update_product_qty_in_cart');

