@extends('backend.master')


@php
    $table_name = 'shipping_methods';
@endphp
@section('table')
    {{ $table_name }}
@endsection

@section('mainContent')

    {!! generateBreadcrumb() !!}

    <section class="admin-visitor-area up_st_admin_visitor">
        <div class="container-fluid p-0">
            <div class="row justify-content-center">

                <div class="col-lg-4">
                    <div class="create_div">
                        @include('store::shipping.pickup_locations.components._create')
                    </div>
                </div>


                <div class="col-lg-8">
                    <div class="white-box">
                        <div class="box_header common_table_header">
                            <div class="main-title d-md-flex">
                                <h3 class="mb-0 mr-30 mb_xs_15px mb_sm_20px" id="page_title">{{ _trans('store.Shipping Pickup Locations') }}</h3>
                            </div>
                        </div>
                        <div class="QA_section QA_section_heading_custom check_box_table">
                            <div class="QA_table">
                                <div id="item_list">
                                    @include('store::shipping.pickup_locations.components._list')
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
    <div id="append_html"></div>

    @include('backend.partials._deleteModalForAjax',['item_name' => _trans('store.Pickup Location'),'form_id' =>
   'pickup_location_delete_form','modal_id' => 'pickup_location_delete_modal', 'delete_item_id' => 'pickup_location_delete_id'])

@endsection

@include('store::shipping.pickup_locations.components._scripts')
