@extends('backend.master')

@php
    $table_name = 'products';

@endphp
@section('table')
    {{ $table_name }}
@stop
@section('mainContent')
    {!! generateBreadcrumb() !!}
    <section class="admin-visitor-area up_st_admin_visitor">
        <div class="container-fluid p-0">

            <div class="row justify-content-center mt-50">
                <div class="col-lg-12">
                    <div class="white_box mb_30">
                        <div class="white_box_tittle list_header">
                            <h4>{{__('courses.Advanced Filter')}} </h4>
                        </div>
                        <form>
                            <div class="row">

                                <div class="col-xl-3 courseBox mb_30">
                                    <label class="primary_input_label" for="author">{{ __('product.Category') }}
                                    </label>
                                    <select class="primary_select category_id" name="category" id="category_id"
                                        {{ $errors->has('category') ? 'autofocus' : '' }}>
                                        <option data-display="{{ __('common.Select') }} {{ __('product.Category') }} *"
                                                value="">{{ __('common.Select') }} {{ __('product.Category') }} </option>
                                        @foreach ($categories as $category)
                                            @if ($category->parent_id == 0)
                                                @include('store::products._single_select_option', [
                                                    'category' => $category,
                                                    'level' => 1,
                                                ])
                                            @endif
                                        @endforeach
                                    </select>
                                </div>

                                <div class="col-sm-3">
                                    <div class="primary_input mb-25">
                                        <label class="primary_input_label"
                                               for="productType">{{ __('product.Type') }}</label>
                                        <select class="primary_select mb-25" name="productType" id="productType">
                                            <option data-display="{{__('common.Select')}}"
                                                    value="">{{__('common.Select')}} </option>
                                            <option
                                                value="1" {{ isset($search_productType)?$search_productType==2 ? 'selected':'':'' }}>{{ __('product.Physical') }}</option>
                                            <option
                                                value="0" {{ isset($search_productType)?$search_productType==1 ? 'selected':'':'' }}>{{ __('product.Virtual') }}</option>
                                        </select>
                                    </div>
                                </div>

                                @if (Auth::user()->role_id == 1)
                                    <div class="col-lg-3">
                                        <label class="primary_input_label" for="users">{{__('product.Seller')}}</label>
                                        <select class="primary_select" name="users" id="users">
                                            <option data-display="{{__('common.Select')}} {{__('product.Seller')}}"
                                                    value="">{{__('common.Select')}} {{__('product.Seller')}}</option>
                                            @foreach ($users as $user)
                                                <option
                                                    value="{{ $user->id }}" {{ isset($search_user)?$search_user==$user->id ? 'selected':'':'' }}>{{ $user->name }}</option>
                                            @endforeach
                                        </select>
                                    </div>
                                @endif


                                <div class="col-12 mt-20">
                                    <div class="search_course_btn text-end">
                                        <button type="submit"
                                                class="primary-btn radius_30px   fix-gr-bg">{{__('courses.Filter')}} </button>
                                    </div>
                                </div>
                            </div>
                        </form>
                    </div>
                </div>

                <div class="col-lg-12">
                    <div class="QA_section QA_section_heading_custom check_box_table">
                        <div class="QA_table">
                            <div class="">
                                <table id="lms_table" class="table classList">
                                    <thead>
                                    <tr>
                                        <th scope="col"> {{ __('common.SL') }}</th>
                                        <th scope="col"> {{ __('common.Name') }}</th>
                                        <th scope="col"> {{ __('product.Product Type') }}</th>
                                        <th scope="col"> {{ __('product.Category') }}</th>
                                        <th scope="col"> {{ __('product.Price') }}</th>
                                        <th scope="col">{{ __('common.Status') }}</th>
                                        <th scope="col">{{ __('common.Action') }}</th>
                                    </tr>
                                    </thead>
                                    <tbody>

                                    </tbody>
                                </table>

                            </div>
                        </div>
                    </div>
                </div>

            </div>


        </div>
    </section>

    @include('store::partials.delete_modal')

@endsection
@push('scripts')
    @php
        $url = route('getAllproduct');
    @endphp

    @php
        $category = request()->get('category');
        $productType = request()->get('productType');
        $users = request()->get('users');
        $date = request()->get('date');

        $url = route('getAllproduct')."?category={$category}&productType={$productType}&users={$users}";
    @endphp

    <script>
        (function ($) {
            "use strict";

            dataTableOptions.serverSide = true
            dataTableOptions.processing = true
            dataTableOptions.ajax = '{!! $url !!}';
            dataTableOptions.columns = [{
                data: 'DT_RowIndex',
                name: 'id'
            },
                {
                    data: 'name',
                    name: 'name'
                },
                {
                    data: 'type',
                    name: 'type'
                },
                {
                    data: 'category',
                    name: 'category.title'
                },

                {
                    data: 'price',
                    name: 'price'
                },
                {
                    data: 'status',
                    name: 'status',
                    orderable: false
                },
                {
                    data: 'action',
                    name: 'action',
                    orderable: false
                },

            ];
            $('#lms_table').DataTable(dataTableOptions);

        })(jQuery);

    </script>
@endpush
