<?php

namespace Modules\Gift\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class GiftRequest extends FormRequest
{
    public function rules()
    {
        return [
            'name' => 'required',
            'email' => 'required|email',
            'date_time' => 'required',
            'message' => 'sometimes|max:500',
        ];
    }


    public function authorize()
    {
        return true;
    }

    public function messages()
    {
        return [
            "name.required" => "Please enter receiver name",
            "email.required" => "Please enter receiver email",
            "email.email" => "Please enter valid email",
            "date_time.required" => "Please enter date and time",
            "message.max" => "Message can not be more than 500 characters",
        ];
    }
}
