<?php

use App\User;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Log;
use Illuminate\Support\Facades\Auth;
use Modules\Gift\Entities\GiftRecord;
use Modules\CourseSetting\Entities\Course;
use Modules\Cashback\Entities\CashbackRule;
use Modules\Cashback\Entities\UserCashback;
use Modules\Cashback\Entities\UserCashbackDetail;

if (!function_exists('cashback')) {
    function cashback($amount)
    {
        $cashback = 0;
        $cashback_rule = \Modules\Cashback\Entities\CashbackRule::where('status', 1)->first();
        if ($cashback_rule) {
            if ($cashback_rule->type == 'fixed') {
                $cashback = $cashback_rule->amount;
            } else {
                $cashback = ($amount * $cashback_rule->amount) / 100;
            }
        }
        return $cashback;
    }
}

if (!function_exists('json_trans')) {
    function json_trans($json, $lang = null)
    {
        if ($lang == null) {
            $lang = app()->getLocale();
        }
        $json = json_decode($json, true);
        if (isset($json[$lang])) {
            return $json[$lang];
        }
        return '';
    }
}
function giveCashback($user_id, $purchase_amount, $cashback_amount, $cashback_source, $cashback_rule, $source_details, $cart = null)
{

    try {
        DB::beginTransaction();
        $cashback = UserCashback::where('user_id', $user_id)->first();
        $check_cashback_details = null;
        if ($cashback) {
            $check_cashback_details = UserCashbackDetail::where('user_cashback_id', $cashback->id)->where('rule_id', $cashback_rule->id)->first();
        }
        if ($cashback_rule->apply_cashback_per_item != 1 && $check_cashback_details) {
            return;
        }
        $user = User::find($user_id);
        if (!$cashback) {
            $cashback = new UserCashback();
        }
        $cashback->user_id = $user_id;
        $cashback->purchase_amount += $purchase_amount;
        $cashback->cashback_amount += $cashback_amount;
        $cashback->last_cashback_datetime = date('Y-m-d H:i:s');
        $cashback->save();

        if ($cashback) {
            $user_cashback_details = new UserCashbackDetail();
            $user_cashback_details->user_cashback_id = $cashback->id;
            $user_cashback_details->rule_id = $cashback_rule->id;
            $user_cashback_details->product_type = $cashback_source;
            $user_cashback_details->product_id = $source_details->id;
            $user_cashback_details->purchase_amount = $purchase_amount;
            $user_cashback_details->cashback_amount = $cashback_amount;
            $user_cashback_details->cashback_datetime = date('Y-m-d H:i:s');
            $user_cashback_details->description = json_encode($source_details);
            $user_cashback_details->status = 'paid';
            if (isModuleActive('Gift') && isset($cart->is_gift) && $cart->is_gift == 1) {
                $user_cashback_details->is_gift = 1;
                $gift_record = GiftRecord::where('cart_id', $cart->id)->first();
                if ($gift_record) {
                    $user_cashback_details->gift_id = $gift_record->id;
                    $user_cashback_details->gifted_by = $user_id;
                }
            }
            if (isModuleActive('Subscription') && $cashback_source == 'subscription') {
                $user_cashback_details->subscription_enrolled_id = $cart->id;
            }
            $user_cashback_details->save();
        }
        if ($user_cashback_details) {
            $user->balance += $cashback_amount;
            $user->save();
        }
        DB::commit();
        return true;
    } catch (\Throwable $th) {
        DB::rollBack();
        return false;
    }
}

function generateCashback($user_id, $purchase_amount, $cashback_source, $source_details, $cart = null, $plan_price = null)
{

    try {
        if (Auth::user()->is_cashback_enabled != 1) {
            return false;
        }
        $target_type_array = [];

        switch ($cashback_source) {
            case 'course':
                $target_type_array = ['all_course', 'specific_course', 'specific_category', 'specific_instructor'];
                break;
            case 'upcoming_course':
                $target_type_array = ['all_course', 'specific_course', 'specific_category', 'specific_instructor'];
                break;
            case 'quiz':
                $target_type_array = ['all_quiz', 'specific_quiz', 'specific_instructor'];
                break;
            case 'live_class':
                $target_type_array = ['all_live_class', 'specific_class', 'specific_instructor'];
                break;
            case 'subscription':
                $target_type_array = ['all_subscription', 'specific_subscription'];
                break;
            case 'recharge':
                $target_type_array = ['recharge'];
                break;

            default:

                break;
        }
        $product_info = null;
        if (in_array($cashback_source, ['course', 'quiz', 'live_class', 'upcoming_course'])) {
            $product_info = Course::find($source_details->id);
        }


        $cashbacks = CashbackRule::where('status', 1)->with('rule_specific_item', 'users', 'rule_specific_item.rule_specific_item_details_relation')
            ->whereHas('rule_specific_item', function ($query) use ($cashback_source) {
                $query->whereIn('target_type', [$cashback_source, 'all']);
            })
            ->where('start_datetime', '<=', date('Y-m-d H:i:s'))
            ->where(function ($query) {
                $query->where('end_datetime', '>=', date('Y-m-d H:i:s'))->orWhereNull('end_datetime');
            })
            ->when(isModuleActive('Subscription') && $cashback_source == 'subscription', function ($query) use ($plan_price) {
                $query->where(function ($query) use ($plan_price) {
                    $query->where('min_purchase_amount', '<=', $plan_price)->orWhereNull('min_purchase_amount');
                });
            })
            ->when($cashback_source != 'subscription', function ($query) use ($purchase_amount) {
                $query->where(function ($query) use ($purchase_amount) {
                    $query->where('min_purchase_amount', '<=', $purchase_amount)->orWhereNull('min_purchase_amount');
                });
            })
            ->where(function ($query) use ($user_id) {
                $query->where('user_type', 'all')->orWhereHas('users', function ($query) use ($user_id) {
                    $query->where('user_id', $user_id);
                });
            })
            ->get();
        $selected_rule = null;
        $product_id = $source_details->id;
        foreach ($cashbacks as $key => $cashback) {
            if ($cashback->rule_specific_item->target_type == 'all') {
                $selected_rule = $cashback;
                break;
            }
            if ($cashback->rule_specific_item->target_type == 'recharge') {
                $selected_rule = $cashback;
                break;
            }
            $cashback_rule_target = $cashback->rule_specific_item->target;
            if (in_array($cashback_rule_target, $target_type_array)) {
                $assigned_items = $cashback->rule_specific_item->rule_specific_item_details();
                if ($cashback_rule_target == 'specific_instructor') {
                    if (in_array($product_info->user_id, $assigned_items)) {
                        $selected_rule = $cashback;
                        break;
                    }
                }
                if ($cashback_rule_target == 'specific_category') {
                    if (in_array($product_info->category_id, $assigned_items)) {
                        $selected_rule = $cashback;
                        break;
                    }
                }
                if ($cashback_rule_target == 'specific_course') {
                    if (in_array($product_id, $assigned_items)) {
                        $selected_rule = $cashback;
                        break;
                    }
                }
                if ($cashback_rule_target == 'specific_quiz') {
                    if (in_array($product_id, $assigned_items)) {
                        $selected_rule = $cashback;
                        break;
                    }
                }
                if ($cashback_rule_target == 'specific_class') {
                    if (in_array($product_id, $assigned_items)) {
                        $selected_rule = $cashback;
                        break;
                    }
                }
                if ($cashback_rule_target == 'specific_subscription') {
                    if (in_array($product_id, $assigned_items)) {
                        $selected_rule = $cashback;
                        break;
                    }
                }
                if (in_array($cashback_rule_target, ['all_course', 'all_quiz', 'all_live_class', 'all_subscription'])) {
                    $selected_rule = $cashback;
                    break;
                }
            }
        }
        if ($selected_rule) {
            $cashback_amount = 0;
            if ($selected_rule->amount_type == 'fixed_amount') {
                $cashback_amount = $selected_rule->amount;
            } else {
                $cashback_amount = ($purchase_amount * $selected_rule->amount) / 100;
            }
            giveCashback($user_id, $purchase_amount, $cashback_amount, $cashback_source, $selected_rule, $source_details, $cart);
        }
        return true;
    } catch (\Throwable $th) {
        return false;
    }

}

function checkProductCashback($product)
{
    try {
        if (Auth::user()->is_cashback_enabled != 1) {
            return false;
        }
        $purchase_amount = 0;
        if ($product->discount_price != null) {
            $purchase_amount = $product->discount_price;
        } else {
            $purchase_amount = $product->price;
        }
        $cashback_source = '';
        switch ($product->type) {
            case '1':
                $cashback_source = 'course';
                break;
            case '2':
                $cashback_source = 'quiz';
                break;
            case '3':
                $cashback_source = 'live_class';
                break;
            default:

                break;
        }

        $target_type_array = [];

        switch ($cashback_source) {
            case 'course':
                $target_type_array = ['all_course', 'specific_course', 'specific_category', 'specific_instructor'];
                break;
            case 'upcoming_course':
                $target_type_array = ['all_course', 'specific_course', 'specific_category', 'specific_instructor'];
                break;
            case 'quiz':
                $target_type_array = ['all_quiz', 'specific_quiz', 'specific_instructor'];
                break;
            case 'live_class':
                $target_type_array = ['all_live_class', 'specific_class', 'specific_instructor'];
                break;

            default:

                break;
        }
        $product_info = null;
        if (in_array($cashback_source, ['course', 'quiz', 'live_class', 'upcoming_course'])) {
            $product_info = Course::find($product->id);
        }


        $cashbacks = CashbackRule::where('status', 1)->with('rule_specific_item', 'users', 'rule_specific_item.rule_specific_item_details_relation')
            ->whereHas('rule_specific_item', function ($query) use ($cashback_source) {
                $query->whereIn('target_type', [$cashback_source, 'all']);
            })
            ->where('start_datetime', '<=', date('Y-m-d H:i:s'))
            ->where(function ($query) {
                $query->where('end_datetime', '>=', date('Y-m-d H:i:s'))->orWhereNull('end_datetime');
            })
            ->where(function ($query) use ($purchase_amount) {
                $query->where('min_purchase_amount', '<=', $purchase_amount)->orWhereNull('min_purchase_amount');
            })
            ->where(function ($query) {
                $query->where('user_type', 'all')->orWhereHas('users', function ($query) {
                    $query->where('user_id', auth()->user()->id);
                });
            })
            ->get();
        $selected_rule = null;
        $product_id = $product->id;
        foreach ($cashbacks as $key => $cashback) {
            if ($cashback->rule_specific_item->target_type == 'all') {
                $selected_rule = $cashback;
                break;
            }
            if ($cashback->rule_specific_item->target_type == 'recharge') {
                $selected_rule = $cashback;
                break;
            }
            $cashback_rule_target = $cashback->rule_specific_item->target;
            if (in_array($cashback_rule_target, $target_type_array)) {
                $assigned_items = $cashback->rule_specific_item->rule_specific_item_details();
                if ($cashback_rule_target == 'specific_instructor') {
                    if (in_array($product_info->user_id, $assigned_items)) {
                        $selected_rule = $cashback;
                        break;
                    }
                }
                if ($cashback_rule_target == 'specific_category') {
                    if (in_array($product_info->category_id, $assigned_items)) {
                        $selected_rule = $cashback;
                        break;
                    }
                }
                if ($cashback_rule_target == 'specific_course') {
                    if (in_array($product_id, $assigned_items)) {
                        $selected_rule = $cashback;
                        break;
                    }
                }
                if ($cashback_rule_target == 'specific_quiz') {
                    if (in_array($product_id, $assigned_items)) {
                        $selected_rule = $cashback;
                        break;
                    }
                }
                if ($cashback_rule_target == 'specific_class') {
                    if (in_array($product_id, $assigned_items)) {
                        $selected_rule = $cashback;
                        break;
                    }
                }
                if ($cashback_rule_target == 'specific_subscription') {
                    if (in_array($product_id, $assigned_items)) {
                        $selected_rule = $cashback;
                        break;
                    }
                }
                if (in_array($cashback_rule_target, ['all_course', 'all_quiz', 'all_live_class', 'all_subscription'])) {
                    $selected_rule = $cashback;
                    break;
                }
            }
        }

        $cashback_amount = 0;
        if ($selected_rule) {
            if ($selected_rule->amount_type == 'fixed_amount') {
                $cashback_amount = $selected_rule->amount;
            } else {
                $cashback_amount = ($purchase_amount * $selected_rule->amount) / 100;
            }
        }
        return $cashback_amount;
    } catch (\Throwable $th) {
        return false;
    }
}
