<div class="tutor_listing_details_preview">
    <div class="tutor_listing_preview">
        <div class="tutor_listing_details_preview_inner_card">
            <div class="tutor_listing_preview_img">
                <img src="{{ getProfileImage($instructor->image, $instructor->name) }}" alt="">
                @if($instructor->short_video_link)
                    <a href="{{$instructor->short_video_link}}" class="tutor_listing_preview_video popup-video"><i
                            class="fa fa-play"></i></a>
                @endif
            </div>
            <div class="tutor_listing_item_info_price">
                <h3>{{ getPriceFormat($instructor->hour_rate) }} <small>/ {{ __('appointment.Hr.') }}</small></h3>

                @if ($settings->trail_lesson == 1)
                    @if(!empty($trial_booked_instructors) && $trial_booked_instructors->where('instructor_id',$instructor->id)->first())
                        <a href="#"
                           class="theme_btn ">{{ __('appointment.Booked Trial Lesson') }}</a>
                    @else
                        <a href="{{ route('book-trail-lesson', [$instructor->slug ?? $instructor->id]) }}"
                           class="theme_btn ">{{ __('appointment.Book Trial Lesson') }}</a>
                    @endif

                @endif
                @if(!empty($wishlist_instructors) && $wishlist_instructors->where('instructor_id',$instructor->id)->first())
                    <a href="#"
                       class="theme_btn bg-transparent">
                        {{ __('appointment.Added to Wishlist') }}
                    </a>
                @else
                    <a href="{{ route('store.wishlist', [$instructor->slug ?? $instructor->id]) }}"
                       class="theme_btn bg-transparent">
                        {{ __('appointment.Add to Wishlist') }}
                    </a>
                @endif
            </div>
            @if($settings->lesson_booked ==1)

                <div class='tutor_listing_details_preview_card'>
                    <div>
                        <img
                            src="{{ asset('Modules/Appointment/Resources/assets/frontend/') }}/img/all-icons/interlocking.svg"
                            alt="">
                    </div>
                    <div>
                        <p>{{ count($instructor->lastDayBooked) }} {{ __('appointment.lessons booked in the last 48 hours') }}
                            .</p>
                    </div>
                </div>
            @endif
        </div>
    </div>
    @if($settings->popular ==1)
        <div class='tutor_listing_details_preview_card'>
            <div>
                <img src="{{ asset('Modules/Appointment/Resources/assets/frontend/') }}/img/all-icons/star.svg" alt="">
            </div>
            <div>
                <h5>{{ __('appointment.Popular') }}</h5>
                <p>{{ count($instructor->lastDayContact) }} {{ __('appointment.students contacted tutor in the last 48 hours') }}
                    .</p>
            </div>
        </div>
    @endif
</div>
