<?php

namespace Modules\Appointment\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Routing\Controller;
use Illuminate\Support\Facades\DB;
use Brian2694\Toastr\Facades\Toastr;
use Modules\SystemSetting\Entities\EmailTemplate;
use Modules\Appointment\Http\Requests\ScheduleRequest;
use Modules\Appointment\Repositories\Interfaces\ScheduleRepositoryInterface;
use Modules\Appointment\Repositories\Interfaces\InstructorRepositoryInterface;

class ScheduleController extends Controller
{
    public $scheduleRepository;
    public $instructorRepository;

    public function __construct(
        ScheduleRepositoryInterface   $scheduleRepository,
        InstructorRepositoryInterface $instructorRepository
    )
    {
        $this->scheduleRepository = $scheduleRepository;
        $this->instructorRepository = $instructorRepository;
    }

    public function index($next_date = null, $pre_date = null)
    {
        
        $data = $this->scheduleRepository->index($next_date, $pre_date);
        return view('appointment::schedule.index', $data);
    }

    public function searchInstructorSchedule(Request $request)
    { 

        $instructor = $this->instructorRepository->findById($request->instructor);
        $slug = $instructor->slug ?? $instructor->id ;
        return redirect()->route('appointment.schedule.instructor-schedule', $slug);
    }

    public function nextWeek(Request $request)
    {
        $data = $this->scheduleRepository->changeWeek($request->all());
        return view('appointment::schedule.inc.schedule', $data);
    }

    public function preSchedule(Request $request)
    {
        $instructor = $this->instructorRepository->findById($request->instructor);
        $data = $this->scheduleRepository->schedule($instructor->slug);
        return view('appointment::schedule.inc.schedule', $data);
    }

    public function instructorSchedule($slug)
    {
        $data = $this->scheduleRepository->schedule($slug);
        return view('appointment::schedule.index', $data);
    }

    public function create()
    {
        return view('appointment::create');
    }

    public function store(ScheduleRequest $request)
    {

        $this->scheduleRepository->create($request->all());
        return response()->json(['message' => 'Operation successful']);

    }

    public function update(ScheduleRequest $request, $id)
    {

        $data = $this->scheduleRepository->update($id, $request->except('_token'));
        if ($data == false) {
            return response()->json(['waringMsg' => 'Time Slot Not Available']);
        }
        return response()->json(['successMsg' => 'Operation successful']);
    }

    public function getUserSchedule(Request $request)
    {
        $userSchedules = $this->scheduleRepository->userSchedule($request->except('_token'));
        return response()->json(['userSchedules' => $userSchedules]);
    }

    public function getUserTimeSlot(Request $request)
    {
        $userTimeSlots = $this->scheduleRepository->userTimeSlot($request->except('_token'));
        return response()->json(['userTimeSlots' => $userTimeSlots]);
    }

    public function setSchedule(Request $request)
    {
        
        $this->scheduleRepository->setSchedule($request->except('_token'));
        Toastr::success(trans('common.Operation successful'), trans('common.Success'));
        return redirect()->back();
    }

    public function destroy($id)
    {

        if ($this->scheduleRepository->deleteById($id)) {
            Toastr::success(trans('common.Operation successful'), trans('common.Success'));
        }
        return redirect()->back();
    }
}
