<?php if(Settings('instructor_reg') ==1): ?>
    <div class="modal fade" id="Instructor" tabindex="-1" role="dialog"
         aria-labelledby="InstructorTitle" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered" role="document">
            <div class="modal-content cs_modal">
                <div class="modal-header">
                    <h5 class="modal-title"
                        id="InstructorTitle"><?php echo e(__('frontendmanage.Become Instructor')); ?></h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true" class="ti-close"></span>
                    </button>
                </div>
                <div class="modal-body">
                    <form action="<?php echo e(route('register')); ?>" method="POST">
                        <?php echo csrf_field(); ?>
                        <div class="form-row">
                            <div class="form-group col-md-12">
                                <input type="text" class="form-control "
                                       placeholder="<?php echo e(__('student.Enter Full Name')); ?>*"
                                       aria-label="Username"
                                       name="name" value="<?php echo e(old('name')); ?>">
                            </div>
                        </div>
                        <div class="form-row">
                            <div class="form-group col-md-12">
                                <input type="email" class="form-control "
                                       placeholder="<?php echo e(__('common.Enter Email')); ?>*"
                                       aria-label="email" name="email" value="<?php echo e(old('email')); ?>">

                            </div>
                            <div class="form-group col-md-12">
                                <input type="text" class="form-control "
                                       placeholder="<?php echo e(__('common.Enter Phone Number')); ?>"
                                       aria-label="phone" name="phone" value="<?php echo e(old('phone')); ?>">
                            </div>
                        </div>

                        <div class="form-row">
                            <div class="form-group col-md-12">
                                <input type="password" class="form-control"
                                       placeholder="<?php echo e(__('frontend.Enter Password')); ?>*"
                                       autocomplete="new-password"
                                       aria-label="password" name="password">

                            </div>
                            <div class="form-group col-md-12">
                                <input type="password" class="form-control"
                                       placeholder="<?php echo e(__('common.Enter Confirm Password')); ?>*"
                                       name="password_confirmation"
                                       aria-label="password_confirmation">

                            </div>
                        </div>


                        <div class="col-12 ">
                            <div class="remember_forgot_pass d-flex align-items-center">
                                <label class="primary_checkbox d-flex" for="checkbox">
                                    <input type="checkbox" id="checkbox">
                                    <span class="checkmark mr_15"></span>
                                    <span><?php echo e(__('frontend.By signing up, you agree to')); ?>

                                                            <a target="_blank" href="<?php echo e(route('privacy')); ?>">
                                                                <?php echo e(__('frontend.Terms of Service and Privacy Policy')); ?>.
                                                            </a>
                                                        </span>

                                </label>

                            </div>

                        </div>
                        <input type="hidden" name="type" value="Instructor">
<?php if(\Illuminate\Support\Facades\Auth::check()): ?>
    <span class="text-danger">
        <?php echo e(__('common.Already logged in as')); ?> <?php echo e(Auth::user()->role?->name); ?>

    </span>
                        <?php else: ?>
                            <button type="submit" class="theme_btn small_btn2" id="submitBtn">
                                <?php echo e(__('common.Register')); ?>

                            </button>
<?php endif; ?>

                    </form>
                </div>
            </div>
        </div>
    </div>
<?php endif; ?>
<?php /**PATH /home/minialms/app.minialms.com/resources/views/frontend/infixlmstheme/snippets/components/_single_popup_instructor_sign_up.blade.php ENDPATH**/ ?>