<?php
    $LanguageList = getLanguageList();
?>
<div class="modal fade admin-query" id="CreateModal" x-data="{custom:false}">
    <div class="modal-dialog modal-dialog-centered">
        <div class="modal-content">
            <div class="modal-header">
                <h4 class="modal-title"><?php echo e(__('footer.Add Link')); ?></h4>
                <button type="button" class="btn-close" data-bs-dismiss="modal"><i class="ti-close "></i></button>
            </div>
            <form method="POST" action="<?php echo e(route('footerSetting.footer.widget-store')); ?>">
                <?php echo csrf_field(); ?>
                <div class="modal-body">
                    <div class="row pt-0">
                        <?php if(isModuleActive('FrontendMultiLang')): ?>
                            <ul class="nav nav-tabs no-bottom-border  mt-sm-md-20 mb-10 ms-3"
                                role="tablist">
                                <?php $__currentLoopData = $LanguageList; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $language): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <li class="nav-item">
                                        <a class="nav-link  <?php if(auth()->user()->language_code == $language->code): ?> active <?php endif; ?>"
                                           href="#element_add<?php echo e($language->code); ?>"
                                           role="tab"
                                           data-bs-toggle="tab"><?php echo e($language->native); ?>  </a>
                                    </li>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </ul>
                        <?php endif; ?>
                    </div>
                    <div class="tab-content">
                        <?php $__currentLoopData = $LanguageList; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $language): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <div role="tabpanel"
                                 class="tab-pane fade <?php if(auth()->user()->language_code == $language->code): ?> show active <?php endif; ?>  "
                                 id="element_add<?php echo e($language->code); ?>">
                                <div class="row">
                                    <div class="col-md-12 mt-30">
                                        <div class="input-effect">
                                            <label class="primary_input_label mt-1"><?php echo e(__('footer.Page Name')); ?> <span class="required_mark">*</span>
                                            </label>
                                            <input class="primary_input_field name form-control" type="text"
                                                   name="name[<?php echo e($language->code); ?>]"
                                                   autocomplete="off" value="">

                                            <span class="focus-border"></span>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </div>
                    <div class="row">


                        <div class=" ">
                            <div class="input-effect">
                                <input type="hidden" name="category" id="category">
                                
                                
                                
                                
                                
                                
                                <span class="focus-border"></span>
                            </div>
                            <?php $__errorArgs = ['category'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                            <span class="text-danger"><?php echo e($message); ?></span>
                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                        </div>


                        <div class="col-lg-12 mt-30">
                            <div class="primary_input ">
                                <div class="row">
                                    <div class="col-md-12 mb-3">
                                        <label class="primary_input_label"
                                               for="    "> <?php echo e(__('setting.Custom Link')); ?></label>
                                    </div>

                                    <div class="col-md-6">
                                        <div class="row">
                                            <div class="col-4 ">
                                                <label class="primary_checkbox d-flex mr-12"
                                                       for="yes">
                                                    <input type="radio"
                                                           class="common-radio "
                                                           id="yes"
                                                           x-on:click="custom = true"
                                                           name="custom"

                                                           value="1">
                                                    <span
                                                        class="checkmark me-2"></span> <?php echo e(__('common.Yes')); ?>

                                                </label>
                                            </div>
                                            <div class="col-4">
                                                <label class="primary_checkbox d-flex mr-12"
                                                       for="no">
                                                    <input type="radio"
                                                           class="common-radio "
                                                           id="no"
                                                           name="custom"
                                                           x-on:click="custom = false"
                                                           checked
                                                           value="0">
                                                    <span
                                                        class="checkmark me-2"></span> <?php echo e(__('common.No')); ?>

                                                </label>
                                            </div>
                                        </div>


                                    </div>

                                </div>
                            </div>

                        </div>

                        <div class="col-lg-12 mt-30 " x-show="!custom">
                            <div class="input-effect">
                                <label class="primary_input_label mt-1"><?php echo e(__('footer.Select Page')); ?>

                                </label>
                                <select class="primary_select "
                                        name="page" id="page">
                                    <option data-display="<?php echo e(__('footer.Select Page')); ?> " value="">
                                        --<?php echo e(__('footer.Select Page')); ?>--
                                    </option>

                                    <?php $__currentLoopData = $staticPageList; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $page): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <option
                                            value="<?php echo e($page->slug); ?>"><?php echo e($page->title); ?></option>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </select>
                                <span class="focus-border"></span>
                            </div>
                            <?php $__errorArgs = ['page'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                            <span class="text-danger"><?php echo e($message); ?></span>
                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                        </div>

                        <div class="col-lg-12 mt-30 " x-show="custom">
                            <div class="input-effect">
                                <label class="primary_input_label mt-1"><?php echo e(__('footer.Custom Link')); ?>

                                </label>
                                <input class="primary_input_field name form-control" type="url"
                                       name="custom_link"
                                       placeholder="https://google.com"
                                       autocomplete="off" value="">

                                <span class="focus-border"></span>
                            </div>
                            <?php $__errorArgs = ['page'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                            <span class="text-danger"><?php echo e($message); ?></span>
                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                        </div>


                        <div class="mt-40 d-flex gap-3 w-100 justify-content-center">
                            <button type="button" class="primary-btn tr-bg  "
                                    data-bs-dismiss="modal"><?php echo e(__('common.Cancel')); ?></button>
                            <div class="tooltip-wrapper" data-title="" data-original-title="" title="">
                                <button type="submit" class="primary-btn fix-gr-bg tooltip-wrapper "
                                        data-original-title="" title="">
                                    <i class="ti-check"></i>
                                    <?php echo e(__('common.Save')); ?> </button>
                            </div>

                        </div>
                    </div>


                </div>
            </form>
        </div>
    </div>
</div>
<?php /**PATH /home/minialms/app.minialms.com/Modules/FooterSetting/Resources/views/footer/components/widget_create.blade.php ENDPATH**/ ?>