<?php $__env->startPush('styles'); ?>

<?php $__env->stopPush(); ?>
<?php
    $table_name='course_subscriptions';
?>
<?php $__env->startSection('table'); ?>
    <?php echo e($table_name); ?>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('mainContent'); ?>

    <?php echo generateBreadcrumb(); ?>


    <section class="admin-visitor-area up_st_admin_visitor">
        <div class="container-fluid p-0">
            <div class="white-box">

                <div class="row justify-content-center">
                    <div class="col-12">
                        <div class="box_header common_table_header">
                            <div class="main-title d-md-flex">
                                <h3 class="mb-0 mr-30 mb_xs_15px mb_sm_20px" id="page_title"><?php echo e(__('subscription.Plan List')); ?></h3>

                                <ul class="d-flex">
                                    <li><a class="primary-btn radius_30px   fix-gr-bg" data-bs-toggle="modal"
                                           id="add_plan_btn"
                                           data-bs-target="#add_plan" href="#"><i
                                                class="ti-plus"></i><?php echo e(__('subscription.Add Plan')); ?></a></li>
                                </ul>

                            </div>
                        </div>
                    </div>
                    <div class="col-lg-12">
                        <div class="QA_section QA_section_heading_custom check_box_table">
                            <div class="QA_table ">
                                <!-- table-responsive -->
                                <div class="">
                                    <table id="lms_table" class="table Crm_table_active3">
                                        <thead>
                                        <tr>
                                            <th>#</th>
                                            <th scope="col"><?php echo e(__('subscription.Title')); ?></th>
                                            <th scope="col"><?php echo e(__('courses.Categories')); ?></th>
                                            <th scope="col"><?php echo e(__('subscription.Price')); ?></th>
                                            <th scope="col"><?php echo e(__('subscription.About')); ?></th>
                                            <th scope="col"><?php echo e(__('subscription.Button Text')); ?></th>
                                            <th scope="col"><?php echo e(__('subscription.Days')); ?></th>
                                            <?php if(currentTheme()=='tvt'): ?>
                                                <th scope="col"><?php echo e(__('common.Popular')); ?></th>
                                            <?php endif; ?>
                                            <th scope="col"><?php echo e(__('common.Status')); ?></th>
                                            <th scope="col"><?php echo e(__('common.Action')); ?></th>
                                        </tr>
                                        </thead>
                                        <tbody>
                                        <?php $__currentLoopData = $plans; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $plan): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <tr data-item="<?php echo e($plan->id); ?>">
                                                <td>
                                                    <i class="ti-menu"></i>
                                                </td>

                                                <td><?php echo e(@$plan->title); ?></td>
                                                <td>
                                                    <?php if($plan->category_id>1): ?>
                                                        <?php echo e(@$plan->category->name); ?>

                                                    <?php else: ?>
                                                        <?php echo e(__('common.All')); ?>

                                                    <?php endif; ?>
                                                </td>
                                                <td><?php echo e(getPriceFormat($plan->price)); ?></td>
                                                <td><?php echo e(@$plan->about); ?></td>
                                                <td><?php echo e(@$plan->btn_txt); ?></td>
                                                <td><?php echo e(@translatedNumber($plan->days)); ?></td>
                                                <?php if(currentTheme()=='tvt'): ?>
                                                    <td class="nowrap">
                                                        <label class="switch_toggle"
                                                               for="popular_checkbox<?php echo e(@$plan->id); ?>">
                                                            <input type="checkbox"
                                                                   class="changePopular"
                                                                   data-id="<?php echo e(@$plan->id); ?>"
                                                                   data-status="<?php echo e(@$plan->popular); ?>"
                                                                   id="popular_checkbox<?php echo e(@$plan->id); ?>"
                                                                   <?php if(@$plan->popular == 1): ?> checked
                                                                   <?php endif; ?> value="<?php echo e(@$plan->id); ?>">
                                                            <i class="slider round"></i>
                                                        </label>
                                                    </td>
                                                <?php endif; ?>
                                                <td class="nowrap">
                                                    <label class="switch_toggle">
                                                        <input type="checkbox"
                                                               class="<?php if(permissionCheck('subscription.change_status')): ?> status_enable_disable <?php endif; ?> "
                                                               <?php if(@$plan->status == 1): ?> checked
                                                               <?php endif; ?> value="<?php echo e(@$plan->id); ?>">
                                                        <i class="slider round"></i>
                                                    </label>
                                                </td>

                                                <td>
                                                    <div class="dropdown CRM_dropdown">
                                                        <button class="btn btn-secondary dropdown-toggle" type="button"
                                                                id="dropdownMenu2" data-bs-toggle="dropdown"
                                                                aria-haspopup="true"
                                                                aria-expanded="false">
                                                            <?php echo e(__('common.Action')); ?>

                                                        </button>
                                                        <div class="dropdown-menu dropdown-menu-right"
                                                             aria-labelledby="dropdownMenu2">
                                                            <?php if(permissionCheck('subscription.edit')): ?>
                                                                <button data-item="<?php echo e($plan); ?>"
                                                                        class="dropdown-item editplan"
                                                                        type="button"><?php echo e(__('common.Edit')); ?></button>
                                                            <?php endif; ?>

                                                            <?php if($setting->type==2): ?>
                                                                <a href="<?php echo e(route('assignCourseToPlan')); ?>?id=<?php echo e($plan->id); ?>"
                                                                   class="dropdown-item"
                                                                ><?php echo e(__('subscription.Add course')); ?></a>
                                                            <?php endif; ?>

                                                            <?php if(permissionCheck('subscription.delete')): ?>
                                                                <button class="dropdown-item deleteplan"
                                                                        data-id="<?php echo e($plan->id); ?>"
                                                                        type="button"><?php echo e(__('common.Delete')); ?></button>
                                                            <?php endif; ?>
                                                            <a href="<?php echo e(route('subscription.planFeature.index')); ?>?id=<?php echo e($plan->id); ?>"
                                                               class="dropdown-item"
                                                            ><?php echo e(__('subscription.Plan Feature')); ?></a>
                                                        </div>
                                                    </div>
                                                </td>
                                            </tr>

                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        <?php if(count($plans)==0): ?>
                                            <tr>
                                                <td class="text-center" colspan="10">
                                                    <?php echo e(__("common.No data available in the table")); ?>

                                                </td>
                                            </tr>
                                        <?php endif; ?>
                                        </tbody>
                                    </table>
                                </div>
                            </div>
                        </div>
                    </div>
                    <!-- Add Modal Item_Details -->
                    <div class="modal fade admin-query" id="add_plan">
                        <div class="modal-dialog modal_1000px modal-dialog-centered">
                            <div class="modal-content">
                                <div class="modal-header">
                                    <h4 class="modal-title"><?php echo e(__('subscription.Add Plan')); ?></h4>
                                    <button type="button" class="close " data-bs-dismiss="modal">
                                        <i class="ti-close "></i>
                                    </button>
                                </div>

                                <div class="modal-body">
                                    <form action="<?php echo e(route('subscription.plan.store')); ?>" method="POST"
                                          enctype="multipart/form-data">
                                        <?php echo csrf_field(); ?>
                                        <div class="row">
                                            <div class="col-xl-12">
                                                <div class="primary_input mb-25">
                                                    <label class="primary_input_label"
                                                           for=""><?php echo e(__('subscription.Title')); ?>

                                                        <strong class="text-danger">*</strong></label>
                                                    <input class="primary_input_field" name="title" placeholder="-"
                                                           required
                                                           type="text" id="addTitle"
                                                           value="<?php echo e(old('title')); ?>" <?php echo e($errors->first('title') ? 'autofocus' : ''); ?>>
                                                </div>
                                            </div>
                                        </div>

                                        <div class="row">
                                            <div class="col-xl-12">
                                                <label class="primary_input_label d-flex"
                                                       for=""><?php echo e(__('courses.Category')); ?>

                                                </label>
                                                <select class="primary_select category_id mb-25" name="category"
                                                        id="category_id" <?php echo e($errors->has('category') ? 'autofocus' : ''); ?>>
                                                    <option
                                                        data-display="<?php echo e(__('common.Select')); ?> <?php echo e(__('quiz.Category')); ?>"
                                                        value=""><?php echo e(__('common.Select')); ?> <?php echo e(__('quiz.Category')); ?> <span
                                                            class="required_mark">*</span></option>
                                                    <?php $__currentLoopData = $categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                        <?php if($category->parent_id==0): ?>
                                                            <?php echo $__env->make('backend.categories._single_select_option',['category'=>$category,'level'=>1], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                                                        <?php endif; ?>
                                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                </select>
                                            </div>
                                        </div>
                                        <div class="row">
                                            <div class="col-xl-12">
                                                <div class="primary_input mb-25">
                                                    <label class="primary_input_label"
                                                           for=""><?php echo e(__('subscription.Price')); ?> <strong
                                                            class="text-danger">*</strong></label>
                                                    <input class="primary_input_field" name="price" placeholder="0"
                                                           required
                                                           type="number" min="1" id="addPrice" step="any"
                                                           value="<?php echo e(old('price')); ?>" <?php echo e($errors->first('price') ? 'autofocus' : ''); ?>>
                                                </div>
                                            </div>
                                        </div>

                                        <div class="row">
                                            <div class="col-xl-12">
                                                <div class="primary_input mb-25">
                                                    <label class="primary_input_label"
                                                           for=""><?php echo e(__('subscription.Days')); ?> <strong
                                                            class="text-danger">*</strong></label>
                                                    <input class="primary_input_field" name="days" placeholder="0"
                                                           required
                                                           type="number" min="1" id="addDays"
                                                           value="<?php echo e(old('days')); ?>" <?php echo e($errors->first('days') ? 'autofocus' : ''); ?>>
                                                </div>
                                            </div>
                                        </div>

                                        <div class="row">
                                            <div class="col-xl-12">
                                                <div class="primary_input mb-25">
                                                    <label class="primary_input_label"
                                                           for=""><?php echo e(__('subscription.About')); ?> </label>
                                                    <input class="primary_input_field" name="about" placeholder="-"

                                                           type="text" id="addAbout"
                                                           value="<?php echo e(old('about')); ?>" <?php echo e($errors->first('about') ? 'autofocus' : ''); ?>>
                                                </div>
                                            </div>
                                        </div>

                                        <div class="row">
                                            <div class="col-xl-12">
                                                <div class="primary_input mb-25">
                                                    <label class="primary_input_label"
                                                           for=""><?php echo e(__('subscription.Button Text')); ?> <strong
                                                            class="text-danger">*</strong></label>
                                                    <input class="primary_input_field" name="btn_txt" placeholder="-"

                                                           type="text" id="addBtn"
                                                           value="<?php echo e(old('btn_txt')); ?>" <?php echo e($errors->first('btn_txt') ? 'autofocus' : ''); ?>>
                                                </div>
                                            </div>
                                        </div>
                                        <?php if(currentTheme()=='tvt'): ?>
                                            <div class="row">
                                                <div class="col-xl-12">
                                                    <div class="primary_input ">
                                                        <div class="row">
                                                            <div class="col-md-12 ">
                                                                <label class="primary_input_label"
                                                                       for=""> <?php echo e(__('subscription.Is Recurring')); ?>

                                                                    * </label>
                                                            </div>

                                                            <div class="col-md-1 mb-25">
                                                                <label class="primary_checkbox d-flex mr-12">
                                                                    <input type="radio" id=""
                                                                           name="is_recurring"
                                                                           value="0"
                                                                           <?php if(empty(old('is_recurring'))): ?>checked <?php else: ?>
                                                                        <?php echo e(old('is_recurring')==0?"checked":""); ?>

                                                                        <?php endif; ?>
                                                                    >
                                                                    <span
                                                                        class="checkmark me-2"></span> <?php echo e(__('common.No')); ?>

                                                                </label>
                                                            </div>

                                                            <div class="col-md-1 mb-25">
                                                                <label class="primary_checkbox d-flex mr-12">
                                                                    <input type="radio" id=""
                                                                           name="is_recurring"
                                                                           value="1"
                                                                        <?php echo e(old('is_recurring')==1?"checked":""); ?>

                                                                    >
                                                                    <span
                                                                        class="checkmark me-2"></span><?php echo e(__('common.Yes')); ?>

                                                                </label>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        <?php endif; ?>
                                        <div class="col-lg-12 text-center pt_15">
                                            <div class="d-flex justify-content-center">
                                                <button class="primary-btn semi_large2  fix-gr-bg"
                                                        id="save_button_parent"
                                                        type="submit"><i
                                                        class="ti-check"></i> <?php echo e(__('common.Save')); ?> <?php echo e(__('subscription.Plan')); ?>

                                                </button>
                                            </div>
                                        </div>
                                    </form>
                                </div>
                            </div>
                        </div>
                    </div>


                    <div class="modal fade admin-query" id="editplan">
                        <div class="modal-dialog modal_1000px modal-dialog-centered">
                            <div class="modal-content">
                                <div class="modal-header">
                                    <h4 class="modal-title"><?php echo e(__('subscription.Update Plan')); ?></h4>
                                    <button type="button" class="close " data-bs-dismiss="modal">
                                        <i class="ti-close "></i>
                                    </button>
                                </div>

                                <div class="modal-body">
                                    <form action="<?php echo e(route('subscription.plan.update')); ?>" method="POST"
                                          enctype="multipart/form-data">
                                        <?php echo csrf_field(); ?>
                                        <input type="hidden" name="id" value="<?php echo e(old('id')); ?>" id="planId">
                                        <div class="row">
                                            <div class="col-xl-12">
                                                <div class="primary_input mb-25">
                                                    <label class="primary_input_label"
                                                           for=""><?php echo e(__('subscription.Title')); ?> <strong
                                                            class="text-danger">*</strong></label>
                                                    <input class="primary_input_field" name="title" placeholder="-"
                                                           required
                                                           type="text" id="editTitle"
                                                           value="<?php echo e(old('title')); ?>" <?php echo e($errors->first('title') ? 'autofocus' : ''); ?>>
                                                </div>
                                            </div>


                                        </div>
                                        <div class="row">
                                            <div class="col-xl-12">
                                                <label class="primary_input_label d-flex"
                                                       for=""><?php echo e(__('courses.Category')); ?>

                                                </label>
                                                <select class="primary_select category_id mb-25" name="category"
                                                        id="category_id_edit" <?php echo e($errors->has('category') ? 'autofocus' : ''); ?>>
                                                    <option
                                                        data-display="<?php echo e(__('common.Select')); ?> <?php echo e(__('quiz.Category')); ?>"
                                                        value=""><?php echo e(__('common.Select')); ?> <?php echo e(__('quiz.Category')); ?> <span
                                                            class="required_mark">*</span></option>
                                                    <?php $__currentLoopData = $categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                        <?php if($category->parent_id==0): ?>
                                                            <?php echo $__env->make('backend.categories._single_select_option',['category'=>$category,'level'=>1], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                                                        <?php endif; ?>
                                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                </select>
                                            </div>
                                        </div>

                                        <div class="row">
                                            <div class="col-xl-12">
                                                <div class="primary_input mb-25">
                                                    <label class="primary_input_label"
                                                           for=""><?php echo e(__('subscription.Price')); ?> <strong
                                                            class="text-danger">*</strong></label>
                                                    <input class="primary_input_field" name="price" placeholder="-"
                                                           required
                                                           type="number" id="editPrice" min="1" step="any"
                                                           value="<?php echo e(old('price')); ?>" <?php echo e($errors->first('price') ? 'autofocus' : ''); ?>>
                                                </div>
                                            </div>


                                        </div>

                                        <div class="row">
                                            <div class="col-xl-12">
                                                <div class="primary_input mb-25">
                                                    <label class="primary_input_label"
                                                           for=""><?php echo e(__('subscription.Days')); ?> <strong
                                                            class="text-danger">*</strong></label>
                                                    <input class="primary_input_field" name="days" placeholder="-"
                                                           required
                                                           type="number" id="editDays" min="1"
                                                           value="<?php echo e(old('days')); ?>" <?php echo e($errors->first('days') ? 'autofocus' : ''); ?>>
                                                </div>
                                            </div>


                                        </div>

                                        <div class="row">
                                            <div class="col-xl-12">
                                                <div class="primary_input mb-25">
                                                    <label class="primary_input_label"
                                                           for=""><?php echo e(__('subscription.About')); ?> <strong
                                                            class="text-danger">*</strong></label>
                                                    <input class="primary_input_field" name="about" placeholder="-"
                                                           required
                                                           type="text" id="editAbout"
                                                           value="<?php echo e(old('about')); ?>" <?php echo e($errors->first('about') ? 'autofocus' : ''); ?>>
                                                </div>
                                            </div>


                                        </div>
                                        <div class="row">
                                            <div class="col-xl-12">
                                                <div class="primary_input mb-25">
                                                    <label class="primary_input_label"
                                                           for=""><?php echo e(__('subscription.Button Text')); ?> <strong
                                                            class="text-danger">*</strong></label>
                                                    <input class="primary_input_field" name="btn_txt" placeholder="-"
                                                           required
                                                           type="text" id="editBtnTxt"
                                                           value="<?php echo e(old('btn_txt')); ?>" <?php echo e($errors->first('btn_txt') ? 'autofocus' : ''); ?>>
                                                </div>
                                            </div>
                                        </div>
                                        <?php if(currentTheme()=='tvt'): ?>
                                            <div class="row">
                                                <div class="col-xl-12">
                                                    <div class="primary_input ">
                                                        <div class="row">
                                                            <div class="col-md-12 ">
                                                                <label class="primary_input_label"
                                                                       for=""> <?php echo e(__('subscription.Is Recurring')); ?>

                                                                    * </label>
                                                            </div>

                                                            <div class="col-md-1 mb-25">
                                                                <label class="primary_checkbox d-flex mr-12">
                                                                    <input type="radio" id=""
                                                                           name="is_recurring"
                                                                           value="0"
                                                                           <?php if(empty(old('is_recurring'))): ?>checked <?php else: ?>
                                                                        <?php echo e(old('is_recurring')==0?"checked":""); ?>

                                                                        <?php endif; ?>
                                                                    >
                                                                    <span
                                                                        class="checkmark me-2"></span> <?php echo e(__('common.No')); ?>

                                                                </label>
                                                            </div>

                                                            <div class="col-md-1 mb-25">
                                                                <label class="primary_checkbox d-flex mr-12">
                                                                    <input type="radio" id=""
                                                                           name="is_recurring"
                                                                           value="1"
                                                                        <?php echo e(old('is_recurring')==1?"checked":""); ?>

                                                                    >
                                                                    <span
                                                                        class="checkmark me-2"></span><?php echo e(__('common.Yes')); ?>

                                                                </label>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        <?php endif; ?>

                                        <div class="col-lg-12 text-center pt_15">
                                            <div class="d-flex justify-content-center">
                                                <button class="primary-btn semi_large2  fix-gr-bg"
                                                        id="save_button_parent" type="submit"><i
                                                        class="ti-check"></i> <?php echo e(__('subscription.Update Plan')); ?>

                                                </button>
                                            </div>
                                        </div>
                                    </form>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="modal fade admin-query" id="deleteplan">
                        <div class="modal-dialog modal-dialog-centered">
                            <div class="modal-content">
                                <div class="modal-header">
                                    <h4 class="modal-title"><?php echo e(__('common.Delete')); ?> <?php echo e(__('subscription.Plan')); ?> </h4>
                                    <button type="button" class="btn-close" data-bs-dismiss="modal"><i
                                            class="ti-close "></i></button>
                                </div>

                                <div class="modal-body">
                                    <form action="<?php echo e(route('subscription.plan.destroy')); ?>" method="post">
                                        <?php echo csrf_field(); ?>

                                        <div class="text-center">

                                            <h4><?php echo e(__('common.Are you sure to delete ?')); ?> </h4>
                                        </div>
                                        <input type="hidden" name="id" value="" id="planDeleteId">
                                        <div class="mt-40 d-flex justify-content-between">
                                            <button type="button" class="primary-btn tr-bg"
                                                    data-bs-dismiss="modal"><?php echo e(__('common.Cancel')); ?></button>

                                            <button class="primary-btn fix-gr-bg"
                                                    type="submit"><?php echo e(__('common.Delete')); ?></button>

                                        </div>
                                    </form>
                                </div>

                            </div>
                        </div>
                    </div>
                </div>

            </div>
        </div>
    </section>

<?php $__env->stopSection(); ?>
<?php $__env->startPush('scripts'); ?>

    <?php echo $__env->make('subscription::plan.script', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php $__env->stopPush(); ?>


<?php echo $__env->make('backend.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/minialms/app.minialms.com/Modules/Subscription/Resources/views/plan/index.blade.php ENDPATH**/ ?>