<?php use Illuminate\Support\Facades\Auth; ?>

<?php $__env->startSection('mainContent'); ?>
    <style>
        .school-table-style {
            padding: 0px;
        }

        @media (max-width: 576px) {
            .primary-btn.fix-gr-bg {
                font-size: 10px;
                line-height: 25px;
                padding: 0px 10px
            }
        }


    </style>
    <?php echo generateBreadcrumb(); ?>


    <section class="admin-visitor-area up_admin_visitor empty_table_tab">
        <div class="container-fluid p-0">


            <div class="row">
                <div class="col-lg-4">
                    <div class="row">
                        <div class="col-lg-12">
                            <?php if(!config('app.demo_mode')): ?>
                                <?php if(permissionCheck('setting.updateSystem.submit')): ?>
                                    <form method="POST" action="<?php echo e(route('setting.updateSystem.submit')); ?>"
                                          class="form-horizontal" enctype="multipart/form-data">
                                        <?php echo csrf_field(); ?>
                                        <?php endif; ?>
                                        <?php endif; ?>
                                        <div class="white-box mb-20">
                                            <div class="main-title">
                                                <h3 class="mb-20"><?php echo app('translator')->get('setting.Upload From Local Directory'); ?></h3>
                                            </div>
                                            <div class="add-visitor">

                                                <div class="row g-0  input-right-icon mb-20">
                                                    <div class="col">
                                                        <div class="input-effect">
                                                            <input
                                                                class="primary-input form-control <?php echo e($errors->has('content_file') ? ' is-invalid' : ''); ?>"
                                                                readonly="true" type="text"
                                                                placeholder="<?php echo e(isset($editData->file) && @$editData->file != ""? getFilePath3(@$editData->file):trans('common.Browse')); ?> "
                                                                id="placeholderUploadContent" name="content_file">
                                                            <span class="focus-border"></span>
                                                            <?php if($errors->has('content_file')): ?>
                                                                <span class="invalid-feedback" role="alert">
                                                    <strong><?php echo e($errors->first('content_file')); ?></strong>
                                                </span>
                                                            <?php endif; ?>
                                                        </div>
                                                    </div>
                                                    <div class="col-auto">
                                                        <button class="primary-btn-small-input" type="button">
                                                            <label class="primary-btn small fix-gr-bg"
                                                                   for="upload_content_file"><?php echo app('translator')->get('common.Browse'); ?></label>
                                                            <input type="file" class="d-none form-control"
                                                                   name="updateFile"
                                                                   required
                                                                   id="upload_content_file">
                                                        </button>

                                                    </div>
                                                </div>
                                                <?php
                                                    $tooltip = "";

                                            if (permissionCheck('setting.updateSystem.submit')){
                                                            $tooltip = "";
                                                        }else{
                                                            $tooltip = "You have no permission to add";
                                                        }
                                            if(config('app.demo_mode')){
                                                $tooltip =trans('common.For the demo version, you cannot change this');
                                            }
                                                ?>
                                                <div class="row  ">
                                                    <div class="col-lg-12 text-center">
                                                        <button class="primary-btn fix-gr-bg" data-bs-toggle="tooltip"
                                                                type="submit"
                                                                title="<?php echo e(@$tooltip); ?>">
                                                            <i class="ti-check"></i>
                                                            <?php if(isset($session)): ?>
                                                                <?php echo app('translator')->get('common.Update'); ?>
                                                            <?php else: ?>
                                                                <?php echo app('translator')->get('common.Save'); ?>
                                                            <?php endif; ?>

                                                        </button>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </form>

                        </div>
                    </div>
                </div>
                <div class="col-lg-8">
                    <div class="row">
                        <div class="col-lg-12">
                            <div class="white-box">
                                <div class="main-title">
                                    <h3 class="mb-20"><?php echo e(__('setting.About System')); ?></h3>
                                </div>
                                <div class="add-visitor">
                                    <table style="width:100%; box-shadow: none;"
                                           class="display school-table school-table-style">

                                        <tr>
                                            <td><?php echo e(__('setting.Software Version')); ?></td>
                                            <td>
                                                <?php echo e(translatedNumber(Storage::has('.version')?Storage::get('.version'):Settings('system_version'))); ?>

                                            </td>
                                        </tr>
                                        <tr>
                                            <td><?php echo e(__('setting.Check update')); ?></td>
                                            <td><a href="https://codecanyon.net/user/codethemes/portfolio"
                                                   target="_blank"> <i
                                                        class="ti-new-window"> </i> <?php echo e(__('setting.Update')); ?> </a></td>
                                        </tr>
                                        <tr>
                                            <td> <?php echo e(__('setting.PHP Version')); ?></td>
                                            <td><?php echo e(translatedNumber(phpversion())); ?></td>
                                        </tr>
                                        <tr>
                                            <td> <?php echo e(__('setting.Laravel Version')); ?></td>
                                            <td><?php echo e(translatedNumber(app()->version() )); ?></td>
                                        </tr>
                                        <tr>
                                            <td><?php echo e(__('setting.Curl Enable')); ?></td>
                                            <td><?php
                                                    if  (in_array  ('curl', get_loaded_extensions())) {
                                                        echo trans('common.Enable');
                                                    }
                                                    else {
                                                        echo  trans('common.Disable');
                                                    }
                                                ?></td>
                                        </tr>


                                        <tr>
                                            <td><?php echo e(__('setting.Purchase code')); ?></td>
                                            <td class="text-nowrap">
                                                <?php echo e(__('setting.Verified')); ?>


                                                <?php if(Auth::user()->role_id==1): ?>
                                                    <?php if(!config('app.demo_mode')): ?>
                                                        <?php if ($__env->exists('service::license.revoke')) echo $__env->make('service::license.revoke', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                                                    <?php endif; ?>
                                                <?php endif; ?>
                                            </td>
                                        </tr>


                                        <tr>
                                            <td><?php echo e(__('setting.Install Domain')); ?></td>
                                            <td><?php echo e(Settings('system_domain')); ?></td>
                                        </tr>

                                        <tr>
                                            <td><?php echo e(__('setting.System Activated Date')); ?></td>
                                            <td><?php echo e(Settings('system_activated_date')); ?></td>
                                        </tr>

                                        <tr>
                                            <td><?php echo e(__('setting.Last Update at')); ?></td>
                                            <td>
                                                <?php if($last_update): ?>
                                                    <?php echo e($last_update->created_at); ?>


                                                <?php else: ?>
                                                    <?php echo e(Settings('system_activated_date')); ?>

                                                <?php endif; ?>
                                            </td>
                                        </tr>

                                    </table>
                                </div>
                            </div>

                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>

<?php $__env->stopSection(); ?>





<?php echo $__env->make('backend.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/minialms/app.minialms.com/Modules/Setting/Resources/views/updateSystem.blade.php ENDPATH**/ ?>