<?php $__env->startSection('title'); ?>
    <?php echo e(Settings('site_title')  ? Settings('site_title')  : 'Infix LMS'); ?> | <?php echo e(_trans('cashback.My Cashback')); ?>

<?php $__env->stopSection(); ?>
<?php $__env->startSection('css'); ?> <?php $__env->stopSection(); ?>
<?php $__env->startSection('js'); ?>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('mainContent'); ?>

    <div class="main_content_iner main_content_padding">

        <div class="dashboard_lg_card">
            <div class="container-fluid g-0">
                <div class="row">
                    <div class="col-12">
                        <div class="section__title3 mb_40">
                            <h3 class="mb-0">
                                <?php echo e(_trans('cashback.Cashback history')); ?>

                            </h3>
                        </div>
                    </div>
                    <div class="col-xl-12">
                        <div class="table-responsive">
                            <table class="table custom_table3 mb-0">
                                <thead>
                                <tr>
                                    <th scope="col"><?php echo e(__('common.SL')); ?></th>
                                    <th scope="col"><?php echo e(__('common.Date')); ?></th>
                                    <th scope="col"><?php echo e(__('payment.Amount')); ?>

                                        <?php if(Settings('hide_multicurrency') == 1): ?>
                                            (<?php echo e(auth()->user()->currency->symbol); ?>)
                                        <?php else: ?>
                                             (<?php echo e(auth()->user()->currency->symbol); ?>)
                                        <?php endif; ?>
                                    </th>
                                    <th scope="col"><?php echo e(_trans('cashback.Source')); ?></th>
                                </tr>
                                </thead>
                                <tbody>
                                <?php $__empty_1 = true; $__currentLoopData = $data['cashbackDetails']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $cashbackDetail): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                    <tr>
                                        <td><?php echo e(@$loop->iteration); ?></td>
                                        <td><?php echo e(showDate($cashbackDetail->created_at)); ?></td>
                                        <td><?php echo e(getPriceFormat(@$cashbackDetail->cashback_amount)); ?>   </td>
                                        <td><?php echo e(Str::ucfirst(@$cashbackDetail->product_type)); ?></td>
                                    </tr>

                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                    <tr>
                                        <td class="text-center" colspan="4">
                                            <?php echo e(__('common.No data available in the table')); ?>

                                        </td>
                                    </tr>
                                <?php endif; ?>

                                </tbody>
                            </table>
                            <div class="mt-4">
                                <?php if($data['cashbackDetails'] != null): ?>
                                    <?php echo e($data['cashbackDetails']->links()); ?>

                                <?php endif; ?>

                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>


    <style>
        .modal-dialog {
            max-width: 1000px;
        }
    </style>
<?php $__env->stopSection(); ?>

<?php echo $__env->make(theme('layouts.dashboard_master'), \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/minialms/app.minialms.com/resources/views/frontend/infixlmstheme/pages/my-cashback.blade.php ENDPATH**/ ?>