<?php

namespace Modules\WhatsappSupport\Entities;

use App\Traits\Tenantable;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Modules\WhatsappSupport\Database\factories\SettingsFactory;

class AgentTime extends Model
{
    use Tenantable;

    protected $guarded = [];

    protected $table = 'whatsapp_support_agent_times';

    protected $appends = ['start_time_str','end_time_str'];

    protected static function newFactory()
    {
        return SettingsFactory::new();
    }

    public function getStartTimeStrAttribute()
    {
        return strtotime($this->start);
    }

    public function getEndTimeStrAttribute()
    {
        return strtotime($this->end);
    }

    public function agent()
    {
        return $this->belongsTo(Agents::class, 'agent_id');
    }

}
