<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;
use Modules\RolePermission\Entities\Permission;

class RolePermissionForWhatsappSupport extends Migration
{

    public function up()
    {
        $routes = [
            ['parent_route' => null, 'name' => 'Whatsapp Support', 'route' => 'whatsapp-support', 'type' => 1, 'module' => 'WhatsappSupport'],
            ['parent_route' => 'whatsapp-support', 'name' => 'Settings', 'route' => 'whatsapp-support.settings', 'type' => 2, 'module' => 'WhatsappSupport'],
            ['parent_route' => 'whatsapp-support', 'name' => 'Agents', 'route' => 'whatsapp-support.agents', 'type' => 2, 'module' => 'WhatsappSupport'],
            ['parent_route' => 'whatsapp-support', 'name' => 'Analytics', 'route' => 'whatsapp-support.analytics', 'type' => 2, 'module' => 'WhatsappSupport']
        ];


        if (function_exists('permissionUpdateOrCreate')) {
            permissionUpdateOrCreate($routes);
        }

    }


    public function down()
    {
        //
    }
}
