<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateWhatsappSupportAgentTimesTable extends Migration
{

    public function up()
    {
        Schema::create('whatsapp_support_agent_times', function (Blueprint $table) {
            $table->id();
            $table->foreignId('agent_id')->constrained('whatsapp_support_agents');
            $table->string('day');
            $table->time('start');
            $table->time('end');
            $table->integer('lms_id')->default(1);
            $table->timestamps();
        });
    }

    public function down()
    {
        Schema::dropIfExists('whatsapp_support_agent_times');
    }
}
