<?php

namespace Modules\Survey\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Routing\Controller;
use Brian2694\Toastr\Facades\Toastr;
use Illuminate\Support\Facades\Auth;
use Modules\Survey\Entities\Survey;
use Modules\Survey\Entities\SurveyAssign;
use Illuminate\Contracts\Support\Renderable;
use Modules\Survey\Entities\SurveyAnswerSubmit;

class StudentSurveyController extends Controller
{

    public function studentSurvey()
    {
        try {

            $query = Survey::where('status', 1)
                ->where(
                    fn($query) => $query->where('survey_type', 2)
                        ->orWhere(function ($query) {
                            $ids = SurveyAssign::where('user_id', Auth::id())
                                ->pluck('survey_id')->toArray();
                            $query->whereIn('id', $ids);
                            if (isModuleActive('Org')) {
                                $query->where(function ($q) {
                                    $q->where('audience', 1)
                                        ->orWhere(function ($q) {
                                            $q->where('audience', 2);
                                            if (Auth::check()) {
                                                if (Auth::user()->role_id != 1) {
                                                    $q->whereHas('branches', function ($q) {
                                                        $q->whereIn('branch_id', getAllChildCodeIds(Auth::user()->branch, [Auth::user()->branch->id]));
                                                    });
                                                }
                                            } else {
                                                $q->whereHas('branches', function ($q) {
                                                    $q->where('branch_id', 0);
                                                });
                                            }
                                        });
                                });

                                $query->where(function ($q) {
                                    $q->where('position_audience', 1)
                                        ->orWhere(function ($q) {
                                            $q->where('position_audience', 2);
                                            if (Auth::check()) {
                                                if (Auth::user()->role_id != 1) {
                                                    $q->whereHas('positions', function ($q) {
                                                        $q->where('position_id', Auth::user()->position->id);
                                                    });
                                                }
                                            } else {
                                                $q->whereHas('positions', function ($q) {
                                                    $q->where('position_id', 0);
                                                });
                                            }
                                        });
                                });
                            }
                        })
                );


            if (currentTheme() == 'wetech') {
                $surveys = $query->latest()->get();
            } else {
                $surveys = $query->latest()->paginate();
            }
            return view(theme('pages.mySurvey'), compact('surveys'));
        } catch (\Exception $e) {
            Toastr::error(trans('common.Operation failed'), trans('common.Failed'));
            GettingError($e->getMessage(), url()->current(), request()->ip(), request()->userAgent());
        }
    }

    public function store(Request $request)
    {
        $ids = SurveyAssign::where('user_id', Auth::id())
            ->pluck('survey_id')->toArray();
        $survey = Survey::findOrFail($request->survey_id);

        try {
            if (!empty($request->question)) {
                foreach ($request->question as $key => $question) {
                    if (isset($request->survey_answer[$question])) {
                        if (gettype($request->survey_answer[$question]) == "array") {
                            SurveyAnswerSubmit::where('question_id', $question)
                                ->where('user_id', Auth::id())
                                ->delete();
                            foreach ($request->survey_answer[$question] as $ans) {
                                SurveyAnswerSubmit::create([
                                    'survey_id' => $survey->id,
                                    'user_id' => Auth::id(),
                                    'question_id' => $question,
                                    'assign_id' => 0,
                                    'answer' => $ans,
                                ]);
                            }
                        } else {

                            SurveyAnswerSubmit::updateOrCreate([
                                'survey_id' => $survey->id,
                                'user_id' => Auth::id(),
                                'question_id' => $question,
                            ], [
                                'assign_id' => 0,
                                'answer' => $request->survey_answer[$question] ?? '',
                            ]);
                        }
                    }

                }
            }
            checkGamification('each_survey', 'survey', null, isModuleActive('Org') ? $survey->org_leaderboard_point : 0);

            orgLeaderboardPointCheck('Survey', $survey->org_leaderboard_point, $survey->id);


            Toastr::success(trans('common.Operation successful'), trans('common.Success'));
            return redirect()->route('survey.student_survey');
        } catch (\Exception $e) {
            Toastr::error(trans('common.Operation failed'), trans('common.Failed'));
            GettingError($e->getMessage(), url()->current(), request()->ip(), request()->userAgent());
        }
    }


    public function show($id)
    {
        $survey = Survey::where('id', $id)->with('course', 'questionAssigns')->firstOrFail();
        if ($survey->survey_type != 2) {
            if (!$survey->course->isLoginUserEnrolled) {
                abort(404);
            }
        }
        $submitted_answers = SurveyAnswerSubmit::where('user_id', Auth::id())->where('survey_id', $survey->id)->get();
        return view(theme('pages.survey_participate'), compact('survey', 'submitted_answers'));
    }
}
