<?php

namespace Modules\Subscription\Entities;

use App\Traits\Tenantable;
use Illuminate\Database\Eloquent\Model;
use Modules\CourseSetting\Entities\Course;

class SubscriptionCourseList extends Model
{
    use Tenantable;

    protected $fillable = [];

    public function course()
    {
        return $this->belongsTo(Course::class, 'course_id')->withDefault();
    }

    public function plan()
    {
        return $this->belongsTo(CourseSubscription::class, 'plan_id')->withDefault();
    }
}
