@extends('backend.master')

@php
    $table_name='courses';

@endphp

@php
    $category = request()->category;
    $productType = request()->get('productType');
    $req_users = request()->get('users');
    $date = request()->get('date');
    $product_status = request()->get('product_status');
    $url = route('getAllproduct')."?category={$category}&productType={$productType}&users={$req_users}&product_status={$product_status}";
@endphp


@section('table')
    {{ $table_name }}
@stop
@section('mainContent')
    {!! generateBreadcrumb() !!}
    <section class="admin-visitor-area up_st_admin_visitor">
        <div class="container-fluid p-0">

            <div class="row justify-content-center">
                <div class="col-lg-12">
                    <div class="white_box mb_30">
                        <div class="white_box_tittle list_header main-title mb-0">
                            <h3 class="mb-20">{{__('courses.Advanced Filter')}} </h3>
                        </div>
                        <form>
                            <div class="row">

                                <div class="col-xl-3 courseBox mb_30">
                                    <label class="primary_input_label" for="author">{{ __('product.Category') }}
                                    </label>
                                    <select class="primary_select category_id" name="category" id="category_id"
                                        {{ $errors->has('category') ? 'autofocus' : '' }}>
                                        <option data-display="{{ __('common.Select') }} {{ __('product.Category') }} "
                                                value="">{{ __('common.Select') }} {{ __('product.Category') }} </option>
                                        @foreach ($categories as $category)
                                            @if ($category->parent_id == 0)
                                                @include('store::products._single_select_option', [
                                                    'category' => $category,
                                                    'level' => 1,
                                                ])
                                            @endif
                                        @endforeach
                                    </select>
                                </div>

                                <div class="col-sm-3">
                                    <div class="primary_input mb-25">
                                        <label class="primary_input_label"
                                               for="productType">{{ __('product.Type') }}</label>
                                        <select class="primary_select mb-25" name="productType" id="productType">
                                            <option data-display="{{__('common.Select')}}"
                                                    value="">{{__('common.Select')}} </option>
                                            <option
                                                value="2" {{ isset($search_productType)?$search_productType==2 ? 'selected':'':'' }}>{{ __('product.Physical') }}</option>
                                            <option
                                                value="1" {{ isset($search_productType)?$search_productType==1 ? 'selected':'':'' }}>{{ __('product.Virtual') }}</option>
                                        </select>
                                    </div>
                                </div>

                                @if (Auth::user()->role_id == 1)
                                    <div class="col-lg-3">
                                        <label class="primary_input_label" for="users">{{__('product.Seller')}}</label>
                                        <select class="primary_select" name="users" id="users">
                                            <option data-display="{{__('common.Select')}} {{__('product.Seller')}}"
                                                    value="">{{__('common.Select')}} {{__('product.Seller')}}</option>
                                            @foreach ($users as $user)
                                                <option
                                                    value="{{ $user->id }}" {{ isset($search_user)?$search_user==$user->id ? 'selected':'':'' }}>{{ $user->name }}</option>
                                            @endforeach
                                        </select>
                                    </div>
                                @endif
                                <div class="col-sm-3">
                                    <div class="primary_input mb-25">
                                        <label class="primary_input_label"
                                               for="product_status">{{ __('product.Status') }}</label>
                                        <select class="primary_select mb-25" name="product_status" id="product_status">
                                            <option data-display="{{__('common.Select')}}"
                                                    value="">{{__('common.Select')}} </option>
                                            <option
                                                value="active" {{ isset($product_status)?$product_status=='active' ? 'selected':'':'' }}>{{ __('common.Active') }}</option>
                                            <option
                                                value="inactive" {{ isset($product_status)?$product_status=='inactive' ? 'selected':'':'' }}>{{ __('common.Inactive') }}</option>
                                        </select>
                                    </div>
                                </div>


                                <div class="col-12  ">
                                    <div class="  text-end">
                                        <button type="submit"
                                                class="primary-btn radius_30px fix-gr-bg">{{__('courses.Filter')}} </button>
                                    </div>
                                </div>
                            </div>
                        </form>
                    </div>
                </div>
                <div class="col-12">
                    <div class="white-box">
                        <div class="row">
                            <div class="col-12">
                                <div class="box_header common_table_header">
                                    <div class="main-title d-md-flex mb-0">
                                        <h3 class="mb-0" id="page_title">{{__('product.Products')}}</h3>
                                        <a class="primary-btn radius_30px fix-gr-bg"
                                           href="{{ route('exportAllProduct')."?category={$req_category}&productType={$search_productType}&users={$search_user}&product_status={$product_status}" }}">
                                            {{__('common.Export')}}</a>
                                    </div>

                                </div>
                            </div>
                            <div class="col-lg-12">
                                <div class="QA_section QA_section_heading_custom check_box_table">
                                    <div class="QA_table">
                                        <div class="">
                                            <table id="lms_table" class="table classList">
                                                <thead>
                                                <tr>
                                                    <th scope="col"> {{ __('common.SL') }}</th>
                                                    <th scope="col"> {{ __('common.Name') }}</th>
                                                    <th scope="col"> {{ __('product.Product Type') }}</th>
                                                    <th scope="col"> {{ __('product.Category') }}</th>
                                                    <th scope="col">{{ __('common.Status') }}</th>
                                                    <th scope="col">{{ __('common.Action') }}</th>
                                                </tr>
                                                </thead>
                                                <tbody>

                                                </tbody>
                                            </table>

                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>


            </div>


        </div>
    </section>

    @include('store::partials.delete_modal')

@endsection
@push('scripts')

    <script>
        (function ($) {
            "use strict";
            dataTableOptions.serverSide = true
            dataTableOptions.processing = true
            dataTableOptions.ajax = '{!! $url !!}';
            dataTableOptions.columns = [{
                data: 'DT_RowIndex',
                name: 'id'
            },
                {
                    data: 'title',
                    name: 'title'
                },
                {
                    data: 'type',
                    name: 'type'
                },
                {
                    data: 'category',
                    name: 'category.title'
                },


                {
                    data: 'status',
                    name: 'status',
                    orderable: false
                },
                {
                    data: 'action',
                    name: 'action',
                    orderable: false
                },

            ];
            dataTableOptions = updateColumnExportOption(dataTableOptions, [0, 1, 2, 3]);

            $('#lms_table').DataTable(dataTableOptions);

        })(jQuery);

    </script>
@endpush
