@php
    $selected_attributes=[];
    $selected_attribute_values=[];
    if(isset($product) && $product->type == 2){
     $selected_attributes = $product->variations->pluck('attribute_id')->toArray();
     $selected_attribute_values = $product->variations->pluck('attribute_value_id')->toArray();
    }
 @endphp

<div class="primary_input mb-25">
    <label class="primary_input_label mb-3"
           for="">{{ __('product.Attribute') }} <span
            class="required_mark_theme">*</span></label>
    @foreach ($attributes as $key => $attribute)
        <div class="row">
            <div class="col-md-2">
                <label class="primary_checkbox sku_combination text-nowrap d-flex mr-12  mb-3"
                       for="attribute{{$attribute->id}}">
                    <input type="checkbox" name="attribute[{{$attribute->id}}]"
                           id="attribute{{$attribute->id}}" value="{{$attribute->id}}"
                           {{in_array($attribute->id,$selected_attributes) ? 'checked' : ''}}
                           class="common-radio relationButton selectAttribute">
                    <span
                        class="checkmark me-2"></span> {{ $attribute->title }}
                </label>
            </div>
            <div class="col-md-10">
                <div class="row d-none" id="attributeValueDiv{{$attribute->id}}">

                    @foreach($attribute->values as $key => $value)

                        <div class="col-sm-2">
                            <label class="primary_checkbox sku_combination text-nowrap d-flex mr-12  mb-3"
                                   for="attributeValue{{$value->id}}">
                                <input type="checkbox" name="attribute_value[{{$attribute->id}}]"
                                       id="attributeValue{{$value->id}}" value="{{$value->id}}"
                                       {{in_array($value->id,$selected_attribute_values) ? 'checked' : ''}}
                                       class="common-radio relationButton selectAttributeValue">
                                <span
                                    class="checkmark me-2"></span> {{ $value->value }}
                            </label>
                        </div>
                    @endforeach
                </div>

            </div>
        </div>
    @endforeach
</div>
