@extends('backend.master')


@php
    $table_name='product_authors';
@endphp
@section('table')
    {{$table_name}}
@endsection

@section('mainContent')

    @php
        $LanguageList = getLanguageList();
    @endphp

    {!! generateBreadcrumb() !!}

    <section class="admin-visitor-area up_st_admin_visitor">
        <div class="container-fluid p-0">
            <div class="row">
                <div class="col-lg-4">
                    <div class="white-box mb_30  student-details header-menu">

                        <div class="box_header common_table_header">
                            <div class="main-title d-md-flex mb-0">
                                <h3 class="mb-0"> @if(!isset($edit))
                                        {{__('product.Add New Author') }}
                                    @else
                                        {{__('product.Update Auhtor')}}
                                    @endif</h3>
                                @if(isset($edit))
                                    @if (permissionCheck('store.author.index'))
                                        <a href="{{route('store.author.index')}}"
                                           class="primary-btn small fix-gr-bg ms-4" style="line-height: 25px;"
                                           title="{{__('courses.Add New')}}">+</a>
                                    @endif
                                @endif
                            </div>
                        </div>

                        <div class="row pt-0">
                            @if(isModuleActive('FrontendMultiLang'))
                                <ul class="nav nav-tabs no-bottom-border  mt-sm-md-20 mb-10 ms-3"
                                    role="tablist">
                                    @foreach ($LanguageList as $key => $language)
                                        <li class="nav-item">
                                            <a class="nav-link  @if (auth()->user()->language_code == $language->code) active @endif"
                                               href="#element{{$language->code}}"
                                               role="tab"
                                               data-bs-toggle="tab">{{ $language->native }}  </a>
                                        </li>
                                    @endforeach
                                </ul>
                            @endif
                        </div>


                        @php
                            if (isset($edit)) {
                                $hasPermission = permissionCheck('store.author.update');
                                $actionUrl =route('store.author.update');
                            }else{
                                $hasPermission = permissionCheck('store.author.store');
                                $actionUrl =route('store.author.store');
                            }
                        @endphp

                        <form action="{{$hasPermission ? $actionUrl : '#'}}" method="POST"
                              id="category-form"
                              name="category-form" enctype="multipart/form-data">
                            @csrf

                            <input type="hidden" name="id"
                                   value="{{isset($edit)?$edit->id:0}}">


                            <div class="tab-content">
                                @foreach ($LanguageList as $key => $language)
                                    <div role="tabpanel"
                                         class="tab-pane fade @if (auth()->user()->language_code == $language->code) show active @endif  "
                                         id="element{{$language->code}}">
                                        <div class="row">
                                            <div class="col-xl-12">
                                                <div class="primary_input mb-25">
                                                    <label class="primary_input_label"
                                                           for="nameInput">{{ __('common.Name') }}
                                                        <strong
                                                            class="text-danger">*</strong></label>
                                                    <input name="name[{{$language->code}}]"
                                                           id="nameInput"
                                                           class="primary_input_field name {{ @$errors->has('name') ? ' is-invalid' : '' }}"
                                                           placeholder="{{ __('common.Name') }}"
                                                           type="text"
                                                           value="{{isset($edit)?$edit->getTranslation('title',$language->code):old('title.'.$language->code)}}">

                                                    @if ($errors->has('name'))
                                                        <span class="invalid-feedback d-block mb-10"
                                                              role="alert">
                                                                                    <strong>{{ @$errors->first('name') }}</strong>
                                                                                </span>
                                                    @endif

                                                </div>

                                            </div>
                                        </div>

                                        <div class="row">
                                            <div class="col-xl-12">
                                                <div class="primary_input mb-15">
                                                    <label class="primary_input_label"
                                                           for=""> {{__("common.Description")}} </label>
                                                    <textarea class="primary_textarea height_112"
                                                              name="description[{{$language->code}}]">{{isset($edit)?$edit->getTranslation('description',$language->code):old('description.'.$language->code)}}</textarea>
                                                </div>
                                            </div>

                                        </div>
                                    </div>
                                @endforeach
                                <div class="col-xl-12">
                                    <div class="primary_input mb-25">
                                        <label class="primary_input_label"
                                               for="publication_id">{{ __('store.Publication') }}
                                            <strong
                                                class="text-danger">*</strong></label>
                                        <select class="primary_select mb-25" name="publication_id"
                                                id="publication_id">
                                            <option value="">{{__('common.Select One')}}</option>
                                            @foreach($publications as $i => $publication)
                                                <option value="{{ $publication->id }}"
                                                    {{ isset($edit) && ($edit->publication_id == $publication->id)  ? 'selected' : '' }}>
                                                    {{ $publication->name}}</option>
                                            @endforeach
                                        </select>
                                    </div>
                                </div>
                            </div>
                            <div class="row">


                                <div class="col-lg-12 mt-10">
                                    <div class="  mb-15">

                                        <x-upload-file
                                            name="image"
                                            type="image"
                                            media_id="{{isset($edit)?$edit->image_media?->media_id:''}}"
                                            label="{{ __('common.Image') }}"
                                            note="{{__('student.Recommended size')}} (300x300)"
                                        />
                                    </div>
                                </div>


                                @php
                                    $tooltip = "";
                                    if(!permissionCheck('store.author.store')){
                                          $tooltip = trans("courses.You have no permission to add");
                                      }
                                @endphp
                                <div class="col-lg-12 text-center">
                                    <div class="d-flex justify-content-center pt_20">
                                        <button type="submit"
                                                class="primary-btn semi_large fix-gr-bg"
                                                data-bs-toggle="tooltip" title="{{@$tooltip}}"
                                                id="save_button_parent">
                                            <i class=" fa fa-check "></i>
                                            @if(!isset($edit))
                                                {{ __('common.Save') }}
                                            @else
                                                {{ __('common.Update') }}
                                            @endif
                                        </button>


                                    </div>
                                </div>
                            </div>

                        </form>
                    </div>


                </div>
                <div class="col-lg-8">
                    <div class="white-box">
                        <div class="box_header common_table_header">
                            <div class="main-title d-md-flex mb-0">
                                <h3 class="mb-0" id="page_title">{{__('product.Author List')}}</h3>
                            </div>
                        </div>
                        <div class="  QA_section QA_section_heading_custom check_box_table">
                            <div class="QA_table ">
                                <div class="">
                                    <table id="lms_table" class="table table-data">
                                        <thead>
                                        <tr>
                                            <th scope="col">{{ __('common.SL') }}</th>
                                            <th scope="col">{{ __('common.Name') }}</th>
                                            <th scope="col">{{ __('store.Publication') }}</th>
                                            <th scope="col">{{ __('frontendmanage.Image') }}</th>
                                            <th scope="col">{{ __('common.Status') }}</th>
                                            <th scope="col">{{ __('common.Action') }}</th>
                                        </tr>
                                        </thead>
                                        <tbody>
                                        @foreach($authors as $key => $author)
                                            <tr>
                                                <td>{{++$key}}</td>
                                                <td> {{checkParent($author)}} {{@$author->title }}</td>
                                                <td>{{@$author->publication->name}}</td>
                                                <td>
                                                    <div>
                                                        <img style="width: 70px !important;"
                                                             src="@if(isset($author->image)){{url(@$author->image)}}@endif"
                                                             alt=""
                                                             class="img img-responsive m-2">
                                                    </div>
                                                </td>


                                                <td class="nowrap">
                                                    <x-backend.status :id="$author->id" :status="$author->status"
                                                                      :route="'store.author.status'"></x-backend.status>

                                                </td>

                                                <td>
                                                    <div class="dropdown CRM_dropdown">
                                                        <button class="btn btn-secondary dropdown-toggle" type="button"
                                                                id="dropdownMenu1{{@$author->id}}"
                                                                data-bs-toggle="dropdown"
                                                                aria-haspopup="true"
                                                                aria-expanded="false">
                                                            {{ __('common.Select') }}
                                                        </button>
                                                        <div class="dropdown-menu dropdown-menu-right"
                                                             aria-labelledby="dropdownMenu1{{@$author->id}}">
                                                            @if (permissionCheck('store.author.edit'))
                                                                <a class="dropdown-item edit_brand"
                                                                   href="{{route('store.author.edit',$author->id)}}">{{__('common.Edit')}}</a>
                                                            @endif
                                                            @if (permissionCheck('store.author.destroy'))
                                                                <a onclick="confirm_modal('{{route('store.author.destroy', $author->id)}}');"
                                                                   class="dropdown-item edit_brand">{{__('common.Delete')}}</a>
                                                            @endif
                                                        </div>
                                                    </div>
                                                </td>
                                            </tr>
                                        @endforeach
                                        </tbody>
                                    </table>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>


    @include('store::partials.delete_modal')

@endsection


@push('scripts')
    <script type="application/javascript">
        (function ($) {
            "use strict";
            dataTableOptions = updateColumnExportOption(dataTableOptions, [0, 1]);

            $('#lms_table').DataTable(dataTableOptions);

        })(jQuery);

    </script>
@endpush
