<?php

namespace Modules\Store\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Http\Request;

class BrandRequest extends FormRequest
{
    public function rules(Request $request)
    {
        if (isModuleActive('FrontendMultiLang')) {
            $code = auth()->user()->language_code;
            return [
                "name.{$code}" => ['required'],
            ];
        } else {

            return [
                "name" => ['required']
            ];
        }
    }

    public function messages()
    {
        if (isModuleActive('FrontendMultiLang')) {
            return validationMessage([
                'name.*.required' => 'The Brand name is required',
            ]);
        } else {
            return validationMessage([
                'name.required' => 'The Brand name is required',
            ]);
        }
    }

    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }
}
