<?php

namespace Modules\Store\Http\Controllers;

use Brian2694\Toastr\Facades\Toastr;
use Exception;
use Illuminate\Http\Request;
use Illuminate\Routing\Controller;
use Modules\Store\Http\Requests\CarrierRequest;
use Modules\Store\Repositories\CarrierRepository;

class CarrierController extends Controller
{
    protected $carrierRepo;

    public function __construct(CarrierRepository $carrierRepo)
    {
        $this->carrierRepo = $carrierRepo;
    }

    public function index()
    {
        try {
            $data['title'] = _trans('store.Add Shipping Carriers');
            $data['carriers'] = $this->carrierRepo->all();
            return view('store::shipping.carriers.index', compact('data'));
        } catch (Exception $e) {
            Toastr::error($e->getMessage(), trans('common.Error'));
            return redirect()->back();
        }

    }

    public function status(Request $request)
    {

        $request->validate([
            'id' => 'required'
        ]);
        try {
            $result = $this->carrierRepo->status($request->except('_token'));
            if ($result == 'shipping rate exsist') {
                return response()->json([
                    'status' => 'shipping method exsist'
                ]);
            } else {
                $data['carriers'] = $this->carrierRepo->all();
                return response()->json([
                    'status' => 1,
                    'list' => (string)view('shipping::carriers.components._config', $data)
                ]);
            }
        } catch (\Exception $e) {
            return response()->json(['status' => 0]);
        }
    }


    public function configuration(Request $request)
    {
        $request->validate([
            'email' => 'required',
            'password' => 'required',
        ]);
        try {
            $this->carrierRepo->carrier_credentials($request->except("_token"));
            Toastr::success(__('common.updated_successfully'), __('common.success'));
            return back();
        } catch (\Exception $e) {
            Toastr::error(__('common.error_message'), __('error_message'));
            return redirect()->back();
        }
    }

    public function store(CarrierRequest $request)
    {
        try {
            $carrier = $this->carrierRepo->create($request->all());
            if ($carrier) {
                Toastr::success(trans('common.Operation successful'), trans('common.Success'));
                return redirect()->back();
            } else {
                Toastr::error(trans('common.Operation failed'), trans('common.Failed'));
                return redirect()->back();
            }
        } catch (Exception $e) {
            Toastr::error($e->getMessage(), trans('common.Error'));
            return redirect()->back();
        }
    }

    private function reloadWithData($msg_type = null)
    {
        try {
            $data['carriers'] = $this->carrierRepo->all();
            return response()->json([
                'msg_type' => $msg_type,
                'carrier_list' => (string)view('shipping::carriers.list', $data),
                'config' => (string)view('shipping::carriers.components._config', $data),
            ], 200);
        } catch (Exception $e) {
            Toastr::error($e->getMessage(), trans('common.Error'));
            return response()->json([
                'error' => $e->getMessage()
            ], 503);
        }
    }

    public function edit($id)
    {
        try {
            $data['title'] = _trans('store.Edit Shipping Carriers');
            $data['carriers'] = $this->carrierRepo->all();
            $data['show'] = $this->carrierRepo->find($id);
            return view('store::shipping.carriers.index', compact('data'));
        } catch (Exception $e) {
            Toastr::error($e->getMessage(), trans('common.Error'));
            return redirect()->back();
        }
    }

    public function update(CarrierRequest $request)
    {
        try {
            $carrier = $this->carrierRepo->update($request->all());
            if ($carrier) {
                Toastr::success(trans('common.Operation successful'), trans('common.Success'));
                return redirect()->route('store.carrier.index');
            } else {
                Toastr::error(trans('common.Operation failed'), trans('common.Failed'));
                return redirect()->back();
            }
        } catch (Exception $e) {
            Toastr::error($e->getMessage(), trans('common.Error'));
            return redirect()->back();
        }
    }

    public function destroy($id)
    {
        try {
            $row = $this->carrierRepo->find($id);
            $all = $this->carrierRepo->all();
            $msg_type = '';
            if ($row->type == 'Automatic') {
                $msg_type = 'Automatic';
            } else {
                if (count($all) < 2) {
                    $msg_type = 'last_item';
                } elseif (count($row->shippingMethods) > 0) {
                    $msg_type = 'has_shipping_method';
                } else {
                    $msg_type = 'deleted';
                }

                if ($msg_type == 'deleted') {
                    $this->carrierRepo->delete($id);
                    Toastr::success(trans('common.Operation successful'), trans('common.Success'));
                } elseif ($msg_type == 'last_item') {
                    Toastr::warning(_trans('store.Keep this data,until create another one'), trans('common.Warning'));
                } else {
                    Toastr::warning(_trans('store.Data Already Using'), trans('common.Warning'));
                }
            }
            return redirect()->route('store.carrier.index');

        } catch (Exception $e) {
            Toastr::error($e->getMessage(), trans('common.Error'));
            return redirect()->back();
        }
    }
}
