<?php

namespace Modules\Store\Entities;

use App\City;
use App\State;
use App\Country;
use Illuminate\Database\Eloquent\Model;

class PickupLocation extends Model
{
    protected $fillable = [
        'pickup_location',
        'name',
        'email',
        'phone',
        'address',
        'address_2',
        'city_id',
        'state_id',
        'country_id',
        'pin_code',
        'lat',
        'long',
        'status',
        'is_set',
        'is_default',
        'created_by',
    ];

    public function country()
    {
        return $this->belongsTo(Country::class,'country_id')->withDefault();
    }

    public function state()
    {
        return $this->belongsTo(State::class,'state_id')->withDefault();
    }

    public function city()
    {
        return $this->belongsTo(City::class,'city_id')->withDefault();
    }
    
}
