<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateRefundRequestDetailsTable extends Migration
{
    public function up()
    {
        Schema::create('refund_request_details', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('refund_request_id')->unsigned();
            $table->unsignedBigInteger('order_package_id')->unsigned();
            $table->unsignedBigInteger('seller_id')->unsigned();
            $table->tinyInteger('processing_state')->default(1);
            $table->timestamps();
        });
    }

    public function down()
    {
        Schema::dropIfExists('refund_request_details');
    }
}
