<?php

namespace Modules\RegistrationBonus\Http\Controllers;

use Brian2694\Toastr\Facades\Toastr;
use Exception;
use Illuminate\Contracts\Support\Renderable;
use Illuminate\Http\Request;
use Illuminate\Routing\Controller;
use Modules\RegistrationBonus\Entities\RegistrationBonusSetting;

class RegistrationBonusSettingController extends Controller
{
    public function index()
    {
        try {
            $setting = registrationBonusSetting();
            return view("registrationbonus::settings", compact('setting'));
        } catch (Exception $e) {
            GettingError($e->getMessage(), url()->current(), request()->ip(), request()->userAgent());
        }

    }


    public function update(Request $request)
    {
        $data = $request->all();

        try {
            $bonus = RegistrationBonusSetting::first();
            if (!$bonus) {
                $bonus = new RegistrationBonusSetting();
            }
            $bonus->is_active = isset($data['bonus_status']) ? $data['bonus_status'] : 0;
            $bonus->instant_bonus = isset($data['instant_bonus']) && !isset($data['referral_bonus']) ? $data['instant_bonus'] : 0;
            $bonus->bonus_on_referrer = isset($data['referral_bonus']) && !isset($data['instant_bonus']) ? $data['referral_bonus'] : 0;
            $bonus->bonus_on_purchase = isset($data['referral_purchase']) && !isset($data['instant_bonus']) ? $data['referral_purchase'] : 0;
            $bonus->referrer_users = isset($data['referral_users']) && !isset($data['instant_bonus']) ? $data['referral_users'] : 0;
            $bonus->referrer_amount = isset($data['purchase_amount']) && !isset($data['instant_bonus']) ? $data['purchase_amount'] : 0;
            $bonus->bonus_amount = isset($data['bonus_amount']) ? $data['bonus_amount'] : 0;
            $bonus->save();
            Toastr::success(_trans("common.Operation successful", 'Success'));
            return back();
        } catch (Exception $e) {
            GettingError($e->getMessage(), url()->current(), request()->ip(), request()->userAgent());
        }
    }
}
