@extends('backend.master')
@push('styles')
    <link rel="stylesheet" href="{{asset('public/backend/css/student_list.css')}}"/>
@endpush
@php
    $table_name='users';
@endphp
@section('table')
    {{$table_name}}
@endsection

@section('mainContent')

    {!! generateBreadcrumb() !!}

    <section class="admin-visitor-area up_st_admin_visitor">
        <div class="container-fluid p-0">
            <div class="row justify-content-center">
                <div class="col-12">
                    <div class="box_header common_table_header">
                        <div class="main-title d-md-flex">
                            <h3 class="mb-0 mr-30 mb_xs_15px mb_sm_20px">{{@$data['title']}}</h3>
                        </div>
                    </div>
                </div>
                <div class="col-lg-12 mt-40">
                    <div class="QA_section QA_section_heading_custom check_box_table">
                        <div class="QA_table ">
                            <div class="table-responsive1">
                                <table id="lms_table" class="table Crm_table_active3">
                                    <thead>
                                    <tr>
                                        @foreach ($data['table_columns'] as $th)
                                            <th scope="col">{{ $th }}</th>
                                        @endforeach


                                    </tr>
                                    </thead>
                                    <tbody>
                                    @foreach ($data['purchase_requests'] as $key => $purchase)
                                        @php
                                            $purchase_upfront= $purchase->installmentPayments->where('type','upfront')->first();
                                            $purchase_installments= $purchase->installmentPayments->where('type','!=','upfront');
                                            $installment_count= $purchase_installments->count();
                                            $installment_amount= $purchase_installments->sum('amount');
                                            $overdue=$purchase->overdueInstallment();
                                        @endphp
                                        <tr>
                                            <th>{{ $key + 1 }}</th>
                                            <td>{{ @$purchase->plan->getTranslation('title', auth()->user()->language_code ?? 'en') }}</td>
                                            <td>{{ @$purchase->topic->getTranslation('title', auth()->user()->language_code ?? 'en') }}</td>
                                            <td>{{ showDate(@$purchase->purchase_date) }}</td>
                                            <td>{{ getPriceFormat(@$purchase->total_amount) }}</td>
                                            <td>
                                                {{ getPriceFormat(@$purchase_upfront->amount) }}
                                                {{$purchase_upfront->amount_type == 'percent' ? '('.$purchase_upfront->percentage.'%)' : ''}}
                                            </td>
                                            <td>
                                                {{ getPriceFormat(@$installment_amount) }}
                                                ({{$installment_count.' '._trans('installment.Part')}})
                                            </td>
                                            <td>
                                                {{@$overdue->count()}}
                                            </td>
                                            <td>
                                                {{ $overdue->count() > 0 ? getPriceFormat(@$overdue->sum('amount')) :'N/A' }}
                                            </td>
                                            <td>
                                                {{@$purchase->installmentRemainingDays()}}
                                            </td>
                                            <td>
                                                @if($purchase->payment_status == 'paid')
                                                    <span class="badgerounded-pill badge-warning" style="padding: 10px">
                                                            {{_trans('installment.Waiting for approval')}}
                                                        </span>
                                                @elseif($purchase->payment_status == 'approved')
                                                    <span class="badge badge-success" style="padding: 10px">
                                                            {{_trans('installment.Open')}}
                                                        </span>
                                                @elseif($purchase->payment_status == 'complete')
                                                    <span class="badge badge-success" style="padding: 10px">
                                                            {{_trans('installment.Complete')}}
                                                        </span>
                                                @else
                                                    <span class="badge badge-danger" style="padding: 10px">
                                                            {{_trans('installment.Rejected')}}
                                                        </span>
                                                @endif
                                            </td>
                                            <td>
                                                <div class="dropdown CRM_dropdown">
                                                    <button class="btn btn-secondary dropdown-toggle" type="button"
                                                            id="dropdownMenu2" data-bs-toggle="dropdown"
                                                            aria-haspopup="true"
                                                            aria-expanded="false">
                                                        {{ __('common.Select') }}
                                                    </button>
                                                    <div class="dropdown-menu dropdown-menu-right"
                                                         aria-labelledby="dropdownMenu2">
                                                        @if (permissionCheck('installment.purchase.details'))
                                                            <a class="dropdown-item edit_brand"
                                                               href="{{ route('installment.purchase.details', @$purchase->id) }}">{{ _trans('installment.Show Details') }}</a>
                                                        @endif

                                                    </div>
                                                </div>
                                            </td>
                                        </tr>

                                    @endforeach
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

        </div>
    </section>

@endsection
@push('scripts')

    @if ($errors->any())
        <script>
            (function ($) {
                "use strict";
                @if(Session::has('type'))
                @if(Session::get('type')=="store")
                $('#add_student').modal('show');
                @else
                $('#editStudent').modal('show');
                @endif
                @endif

            })(jQuery);

        </script>
    @endif


    <script src="{{asset('public/backend/js/student_list.js')}}"></script>

@endpush
